% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_correlation.R
\name{show_correlation}
\alias{show_correlation}
\title{Show correlation}
\usage{
show_correlation(
  data,
  method = "pearson",
  diag = TRUE,
  labels = FALSE,
  vjust = 0,
  text_size = 15
)
}
\arguments{
\item{data}{Tibble with results of as returned by the landscapemetrics package.}

\item{method}{Type of correlation. See \code{link{cor}} for details.}

\item{diag}{If FALSE, values on the diagonal will be NA and not plotted.}

\item{labels}{If TRUE, the correlation value will be added as text.}

\item{vjust}{Will be passed on to ggplot2 as vertical justification of x-axis text.}

\item{text_size}{Text size of the plot.}
}
\value{
ggplot
}
\description{
Show correlation
}
\details{
The functions calculates the correlation between all metrics. In order to calculate correlations,
for the landscape level more than one landscape needs to be present. All input
must be structured as returned by the \strong{landscapemetrics} package.
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)

metrics <- calculate_lsm(landscape, what = c("patch", "class"))
show_correlation(data = metrics, method = "pearson")

\dontrun{
metrics <- calculate_lsm(landscape, what = c("patch", "class"))
correlations <- calculate_correlation(metrics)
show_correlation(data = correlations, method = "pearson")
}

}
