% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_extras.R
\name{get_enn_patch}
\alias{get_enn_patch}
\title{get_enn_patch}
\usage{
get_enn_patch(classes, class_patches, points, resolution, verbose = FALSE)
}
\arguments{
\item{classes}{A vector with unique values (output of get_unique_values_int)}

\item{class_patches}{A list with matrices of patches for each class (output of get_class_patches)}

\item{points}{A matrix with three columns: col, row, value (output of get_points)}

\item{resolution}{A vector with two numbers (usually calculated using terra::res)}

\item{verbose}{A logical indicating whether to print warnings}
}
\value{
tibble with two columns: class, value
}
\description{
Euclidean Nearest-Neighbor Distance
}
\details{
Calculate Euclidean Nearest-Neighbor Distance for each patch in each class
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
landscape_mat <- terra::as.matrix(landscape, wide = TRUE)
classes <- landscapemetrics:::get_unique_values_int(landscape_mat)
class_patches <- get_class_patches(landscape_mat, classes, directions = 8)
points <- get_points(landscape_mat, terra::res(landscape))
enns <- get_enn_patch(classes, class_patches, points, terra::res(landscape))

}
\keyword{internal}
