% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_mesh.R
\name{lsm_c_mesh}
\alias{lsm_c_mesh}
\title{MESH (class level)}
\usage{
lsm_c_mesh(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Effective Mesh Size (Aggregation metric)
}
\details{
\deqn{MESH = \frac{\sum \limits_{j = 1}^{n} a_{ij} ^ 2} {A} * \frac{1} {10000}}
where \eqn{a_{ij}} is the patch area in square meters and \eqn{A} is the
total landscape area in square meters.

The effective mesh size is an 'Aggregation metric'. Because each patch is squared
before the sums for each group i are calculated and the sum is standardized by the
total landscape area, MESH is a relative measure of patch structure. MESH is
perfectly, negatively correlated to \code{\link{lsm_c_division}}.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{Hectares}
\subsection{Range}{cell size / total area <= MESH <= total area}
\subsection{Behaviour}{Equals cellsize/total area if class covers only
one cell and equals total area if only one patch is present.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_mesh(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Jaeger, J. A. 2000. Landscape division, splitting index, and effective mesh
size: new measures of landscape fragmentation.
Landscape ecology, 15(2), 115-130.
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{lsm_l_ta}}, \cr
\code{\link{lsm_l_mesh}}
}
