% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{video}
\alias{video}
\title{Generation of a video}
\usage{
video(
  audpc,
  time_param,
  Npatho,
  landscape,
  area,
  rotation,
  croptypes,
  croptype_names = c(),
  cultivars_param,
  audpc100S,
  keyDates = NULL,
  nMapPY = 5,
  path = getwd()
)
}
\arguments{
\item{audpc}{A dataframe containing audpc outputs (generated through epid_output). 1 year per line and
1 column per cultivar, with an additional column for the average audpc in the landscape.}

\item{time_param}{list of simulation parameters:\itemize{
\item Nyears = number cropping seasons,
\item nTSpY = number of time-steps per cropping season.
}}

\item{Npatho}{number of pathogen genotypes.}

\item{landscape}{a sp object containing the landscape.}

\item{area}{a vector containing polygon areas (must be in square meters).}

\item{rotation}{a dataframe containing for each field (rows) and year (columns, named "year_1", "year_2", etc.),
the index of the cultivated croptype. Importantly, the matrix must contain 1 more column than the real number
of simulated years.}

\item{croptypes}{a dataframe with three columns named 'croptypeID' for croptype index,
'cultivarID' for cultivar index and 'proportion' for the proportion of the cultivar within the croptype.}

\item{croptype_names}{a vector of croptype names (for legend).}

\item{cultivars_param}{a list of parameters associated with each host genotype (i.e. cultivars)
when cultivated in pure crops:\itemize{
\item name = vector of cultivar names,
\item max_density = vector of maximum host densities (per square meter) at the end of the cropping season,
\item cultivars_genes_list = a list containing, for each host genotype, the indices of carried resistance genes.
}}

\item{audpc100S}{AUDPC of a 100\% susceptible landscape, used as a reference.}

\item{keyDates}{a vector of times (in timesteps) where to draw vertical lines in the AUDPC graphic. Usually
used to delimit durabilities of the resistance genes. No line is drawn if keyDates=NULL (default).}

\item{nMapPY}{an integer specifying the number of epidemic maps per year to generate.}

\item{path}{path where binary files are located and where the video will be generated.}
}
\value{
A video file of format mp4.
}
\description{
Generates a video showing the epidemic dynamics on a map representing the cropping landscape.
(requires ffmpeg library).
}
\details{
The left panel shows the year-after-year dynamics of AUDPC, relative to a fully susceptible landscape,
for each cultivar as well as the global average. The right panel illustrates the landscape,
where fields are hatched depending on the cultivated croptype, and coloured depending on the prevalence of the disease.
Note that up to 9 different croptypes can be represented properly in the right panel.
}
\examples{
\dontrun{
demo_landsepi()
}
}
