% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{updateSurvivalProb}
\alias{updateSurvivalProb}
\title{Update pathogen survival probability during the off-season}
\usage{
updateSurvivalProb(params, mat_year = NULL, mat_croptype = NULL, mat = NULL)
}
\arguments{
\item{params}{a LandsepiParams object}

\item{mat_year}{a vector of size Nyear, giving survival probabilities for every year
(replicated for every croptype).}

\item{mat_croptype}{a vector of size Ncroptypes, giving survival probabilities for
every croptype (replicated for every year).}

\item{mat}{a matrix of dimension (Nyears, Ncroptypes) giving survival probabilities
for every year (rows)
and every croptype (columns).}
}
\value{
a LandsepiParams object updated.
}
\description{
update survival probability of the pathogen with a probability value for every
simulated year (number of years = Nyears) and every croptype (number of croptypes = Ncroptypes).
Note that time parameters, pathogen and croptypes must be set before updating
survival probabilities.
}
\details{
Unless the matrix \code{mat} is filled, the matrix containing the survival
probability during the offseason
is computed for every year and croptype with
\code{mat[year, croptype] = mat_year[year] * mat_croptype[croptype]}. \cr
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setTime(simul_params, Nyears=10, nTSpY=120)
simul_params <- setPathogen(simul_params, loadPathogen("rust"))

cultivar1 <- loadCultivar(name = "Susceptible", type = "growingHost")
cultivar2 <- loadCultivar(name = "Resistant", type = "growingHost")
cultivars <- data.frame(rbind(cultivar1, cultivar2), stringsAsFactors = FALSE)
simul_params <- setCultivars(simul_params, cultivars)

croptypes <- loadCroptypes(simul_params
, names = c("Susceptible crop", "Resistant crop", "Mixture"))
croptypes <- allocateCroptypeCultivars(croptypes, "Susceptible crop", "Susceptible")
croptypes <- allocateCroptypeCultivars(croptypes, "Resistant crop", "Resistant")
croptypes <- allocateCroptypeCultivars(croptypes, "Mixture", c("Susceptible", "Resistant"))
simul_params <- setCroptypes(simul_params, croptypes)
Ncroptypes <- nrow(simul_params@Croptypes)
Nyears <- simul_params@TimeParam$Nyears

## Same probability in every croptype:
simul_params <- updateSurvivalProb(simul_params, mat_year=1:Nyears/100)
simul_params@Pathogen
## Same probability every year:
simul_params <- updateSurvivalProb(simul_params, mat_croptype=1:Ncroptypes/10)
simul_params@Pathogen
## specific probability for different croptypes and years:
simul_params <- updateSurvivalProb(simul_params
, mat_year=1:Nyears/100, mat_croptype=1:Ncroptypes/10)
simul_params@Pathogen
## One probability per year and per croptype:
simul_params <- updateSurvivalProb(simul_params
, mat=matrix(runif(Nyears*Ncroptypes), ncol=Ncroptypes))
simul_params@Pathogen
survivalProbToMatrix(simul_params)
}
}
\seealso{
\link{survivalProbToMatrix}
}
