% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Math-Functions.R
\name{antideriv_verhulst}
\alias{antideriv_verhulst}
\title{Antiderivative of the Verhulst logistic function}
\usage{
antideriv_verhulst(x, initial_density, max_density, growth_rate)
}
\arguments{
\item{x}{timestep up to which antiderivative must be computed}

\item{initial_density}{initial density}

\item{max_density}{maximal density}

\item{growth_rate}{growth rate}
}
\value{
An object of the same type as x containing the antiderivative of the input values.
}
\description{
Give the antiderivative of the logistic function from the Verhulst model.
}
\details{
The Verhulst model (used to simulate host growth) is defined by
\eqn{ f(x) = max\_{density} / (1 + (max\_{density}/initial\_{density})*exp(-growth\_{rate}*x)) }.
See https://en.wikipedia.org/wiki/Logistic_function for details.
}
\examples{
antideriv_verhulst(119, 0.1, 2, 0.1) / 120
}
