% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{getMatrixGenePatho}
\alias{getMatrixGenePatho}
\title{Get the "resistance gene/pathogen genotype" compatibility matrix.}
\usage{
getMatrixGenePatho(params)
}
\arguments{
\item{params}{a LandsepiParams object.}
}
\value{
an interaction matrix composed of 0 and 1 values.
}
\description{
Build the matrix indicating if infection is possible at the beginning of the season
for every combination of plant resistance gene (rows) and pathogen genotype (columns).
}
\details{
For hosts carrying each resistance gene, there is either possibility of infection
by the pathogen genotype (value of 1), either complete protection (value of 0).
Complete protection only occurs if the resistance gene targets the infection rate,
has a complete efficiency, and is expressed from the beginning of the cropping season
(i.e. this is not an APR).
}
\examples{
\dontrun{
simul_params <- createSimulParams()
gene1 <- loadGene(name = "MG 1", type = "majorGene")
gene2 <- loadGene(name = "MG 2", type = "majorGene")
genes <- data.frame(rbind(gene1, gene2), stringsAsFactors = FALSE)
simul_params <- setGenes(simul_params, genes)
getMatrixGenePatho(simul_params)
}
}
\seealso{
\link{getMatrixCultivarPatho}, \link{getMatrixCroptypePatho}, \link{getMatrixPolyPatho}
}
