% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{calculate_sums}
\alias{calculate_sums}
\title{Calculate ion sums}
\usage{
calculate_sums(data, ..., name_fun = default_name, quiet = F)
}
\arguments{
\item{data}{a data frame with raw ion counts retrieved from \code{\link{load_LANS_summary}}}

\item{...}{the ion sums to calculate, each entry is for one sum of as many ions as desired,
e.g. c(`13C`, `12C`), c(`15N12C`, `14C12C`), ...}

\item{name_fun}{the naming function, receives ... from the top level, default concatenates column names with '+'}

\item{quiet}{whether the function should output information messages or be quiet (default is to output)}
}
\value{
the original data frame with the sums information appended (data_type == "ion_sum")
}
\description{
This function calculates the ion sums and resulting counting
statistics error from multiple raw ion counts. It can be applied to data from both
LANS_summary and LANS_maps loading but can be slow if LANS_maps is combined
from many analyses. Careful about its error propagation, it assumes it is calculating
sums of ions and uses the ion counts themselves for error calculation. This is not 
suitable for calculating other types of sums where other types of error propagation
may be more appropriate.
}
\seealso{
Other calculations: \code{\link{calculate_abundances}},
  \code{\link{calculate_ratios}}, \code{\link{calculate}}
}
