% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_files.R
\name{read_map_data}
\alias{read_map_data}
\title{Read LANS full ion map data (.mat) files}
\usage{
read_map_data(mat_folder, ion_data_only = TRUE, quiet = F)
}
\arguments{
\item{mat_folder}{- the LANS mat directory with the ions' .mat files}

\item{ion_data_only}{- by default TRUE, i.e. ignores all non-ion data files}

\item{quiet}{- whether to report information on the loaded data or not}
}
\value{
concatenated data_frame with the full ion maps data
}
\description{
Reads the full matlab data files (.mat) that contain the complete ion maps and ROI outlines 
for the given LANS analysis folder and returns the data in a concatenated data frame with
identifier column 'variable' (=ion), data columns value (ion count) and sigma (error based on
counting statistics). Additionally, the column 'ROI' indicates which ROI each pixel belongs to
with a value of 0 indicating that it does not belong to any ROI. Note that this only reads ion 
data files by default and not any derived data files (any ratio or other formulas
evaluated by LANS). It does also not currently support z-stacks yet.
}
