% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{saveList}
\alias{saveList}
\title{Save or append elements to a list file.}
\usage{
saveList(object, file, append = FALSE)
}
\arguments{
\item{object}{A list object to save or append.}

\item{file}{Name of file.}

\item{append}{\code{TRUE/FALSE}, \code{TRUE} refers to truncating and saving. 
\code{FALSE} refers to appending.}
}
\value{
\code{TRUE} if no error occurs.
}
\description{
Save or append elements to a list file.
}
\details{
Save or append a list with / without names to a file.
Notice that, all the names will be truncated to 16 characters. The rest attributes of lists
will be discarded. \cr
The generated file is not readable by \code{\link{readRDS}}.
}
\examples{
list1 <- list("A" = c(1,2), "B" = "abc", list(1, 2, 3))
saveList(list1, "example.llo")
}
\seealso{
\code{\link{largeList}}
}

