% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildEdgeMatrix.R
\name{buildWijMatrix}
\alias{buildWijMatrix}
\alias{buildWijMatrix.edgematrix}
\alias{buildWijMatrix.TsparseMatrix}
\alias{buildWijMatrix.CsparseMatrix}
\title{buildWijMatrix}
\usage{
buildWijMatrix(x, threads = NULL, perplexity = 50)

\method{buildWijMatrix}{edgematrix}(x, threads = NULL, perplexity = 50)

\method{buildWijMatrix}{TsparseMatrix}(x, threads = NULL, perplexity = 50)

\method{buildWijMatrix}{CsparseMatrix}(x, threads = NULL, perplexity = 50)
}
\arguments{
\item{x}{An edgematrix, either an `edgematrix` object or a sparse matrix.}

\item{threads}{The maximum number of threads to spawn. Determined automatically if \code{NULL} (the default).}

\item{perplexity}{Given perplexity.}
}
\value{
A \code{list} with the following components: \describe{
   \item{'dist'}{An [N,K] matrix of the distances to the nearest neighbors.}
   \item{'id'}{An [N,K] matrix of the node indexes of the neartest neighbors.  Note that this matrix is 1-indexed,
   unlike most other matrices in this package.}
   \item{'k'}{The number of nearest neighbors.}
 }
}
\description{
Rescale the weights in an edge matrix to match a given perplexity.
}
