% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{subset.lcModels}
\alias{subset.lcModels}
\title{Subsetting a lcModels list based on method arguments}
\usage{
\method{subset}{lcModels}(x, subset, drop = FALSE, ...)
}
\arguments{
\item{x}{The \code{lcModels} or list of \code{lcModel} to be subsetted.}

\item{subset}{Logical expression based on the \code{lcModel} method arguments, indicating
which \code{lcModel} objects to keep.}

\item{drop}{Whether to return a \code{lcModel} object if the result is length 1.}

\item{...}{Not used.}
}
\value{
A \code{lcModels} list with the subset of \code{lcModel} objects.
}
\description{
Subsetting a lcModels list based on method arguments
}
\examples{
data(latrendData)
mKML <- lcMethodKML(response = "Y", id = "Id", time = "Time")
kml1 <- latrend(mKML, nClusters = 1, latrendData)
kml2 <- latrend(mKML, nClusters = 2, latrendData)
kml3 <- latrend(mKML, nClusters = 3, latrendData)
gmm <- latrend(lcMethodLcmmGMM(fixed = Y ~ Time, mixture = ~ Time,
   id = "Id", time = "Time"), latrendData)
models <- lcModels(kml1, kml2, kml3, gmm)

subset(models, nClusters > 1 & .method == 'kml')
}
\seealso{
Other lcModel list functions: 
\code{\link{as.lcModels}()},
\code{\link{lcModels}},
\code{\link{print.lcModels}()}
}
\concept{lcModel list functions}
