% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predict.lcModel}
\alias{predict.lcModel}
\title{lcModel predictions}
\usage{
\method{predict}{lcModel}(object, newdata = NULL, what = "mu", ..., useCluster = NA)
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{newdata}{Optional \code{data.frame} for which to compute the model predictions. If omitted, the model training data is used.
Cluster trajectory predictions are made when ids are not specified.}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}

\item{...}{Additional arguments.}

\item{useCluster}{Whether to use the "Cluster" column in the newdata argument for computing predictions conditional on the respective cluster.
For \code{useCluster = NA} (the default), the feature is enabled if newdata contains the "Cluster" column.}
}
\value{
If \code{newdata} specifies the cluster membership; a \code{data.frame} of cluster-specific predictions. Otherwise, a \code{list} of \code{data.frame} of cluster-specific predictions is returned.
}
\description{
Predicts the expected trajectory observations at the given time for each cluster.
}
\section{Implementation}{

Note: Subclasses of \code{lcModel} should preferably implement \code{\link[=predictForCluster]{predictForCluster()}} instead of overriding \code{predict.lcModel} as that function is designed to be easier to implement because it is single-purpose.

The \code{predict.lcModelExt} function should be able to handle the case where \code{newdata = NULL} by returning the fitted values.
After post-processing the non-NULL newdata input, the observation- and cluster-specific predictions can be computed.
Lastly, the output logic is handled by the \code{\link[=transformPredict]{transformPredict()}} function. It converts the computed predictions (e.g., \code{matrix} or \code{data.frame}) to the appropriate output format.
\preformatted{
predict.lcModelExt <- function(object, newdata = NULL, what = "mu", ...) {
  if (is.null(newdata)) {
    newdata = model.data(object)
    if (hasName(newdata, 'Cluster')) {
      # allowing the Cluster column to remain would break the fitted() output.
      newdata[['Cluster']] = NULL
    }
  }

  # compute cluster-specific predictions for the given newdata
  pred <- NEWDATA_COMPUTATIONS_HERE
  transformPredict(pred = pred, model = object, newdata = newdata)
})
}
}

\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)

predFitted <- predict(model) # same result as fitted(model)

# Cluster trajectory of cluster A
predCluster <- predict(model, newdata = data.frame(Cluster = "A", Time = time(model)))

# Prediction for id S1 given cluster A membership
predId <- predict(model, newdata = data.frame(Cluster = "A", Id = "S1", Time = time(model)))

# Prediction matrix for id S1 for all clusters
predIdAll <- predict(model, newdata = data.frame(Id = "S1", Time = time(model)))
}
\seealso{
\link{predictForCluster} \link[stats:predict]{stats::predict} \link{fitted.lcModel} \link{clusterTrajectories} \link{trajectories} \link{predictPostprob} \link{predictAssignments}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
