% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{subset.lcModels}
\alias{subset.lcModels}
\title{Subsetting a lcModels list based on method arguments}
\usage{
\method{subset}{lcModels}(x, subset, drop = FALSE, ...)
}
\arguments{
\item{x}{The \code{lcModels} or list of \code{lcModel} to be subsetted.}

\item{subset}{Logical expression based on the \code{lcModel} method arguments, indicating
which \code{lcModel} objects to keep.}

\item{drop}{Whether to return a \code{lcModel} object if the result is length 1.}

\item{...}{Not used.}
}
\value{
A \code{lcModels} list with the subset of \code{lcModel} objects.
}
\description{
Subsetting a lcModels list based on method arguments
}
\section{Functionality}{

\itemize{
\item \link[=print.lcModels]{Print} an argument summary for each of the models.
\item \link[=as.data.frame.lcModels]{Convert} to a \code{data.frame} of method arguments.
\item \link[=subset.lcModels]{Subset} the list.
\item Compute an \link[=metric]{internal metric} or \link[=externalMetric]{external metric}.
\item Obtain the best model according to \link[=min.lcModels]{minimizing} or \link[=max.lcModels]{maximizing} a \link[=latrend-metrics]{metric}.
\item Obtain the summed \link[=estimationTime]{estimation time}.
\item \link[=plotMetric]{Plot a metric} across a variable.
\item \link[=plotClusterTrajectories]{Plot the cluster trajectories}.
}
}

\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")

model1 <- latrend(method, latrendData, nClusters = 1)
model2 <- latrend(method, latrendData, nClusters = 2)
model3 <- latrend(method, latrendData, nClusters = 3)

rngMethod <- lcMethodRandom("Y", id = "Id", time = "Time")
rngModel <- latrend(rngMethod, latrendData)

models <- lcModels(model1, model2, model3, rngModel)

subset(models, nClusters > 1 & .method == 'lmkm')
}
\seealso{
Other lcModels functions: 
\code{\link{as.lcModels}()},
\code{\link{lcModels}},
\code{\link{lcModels-class}},
\code{\link{max.lcModels}()},
\code{\link{min.lcModels}()},
\code{\link{plotMetric}()},
\code{\link{print.lcModels}()}
}
\concept{lcModels functions}
