\name{qq}
\alias{qq}
\alias{qq.formula}
\title{ Quantile-Quantile Plots of Two Samples }
\description{
  Quantile-Quantile plots for comparing two Distributions
}
% \synopsis{
% \method{qq}{formula}(formula, data = parent.frame(), aspect = "fill", 
%     panel = panel.qq, prepanel = NULL, scales = list(), strip = TRUE, 
%     groups = NULL, xlab, xlim, ylab, ylim, f.value = NULL, 
%     drop.unused.levels,
%     \dots, default.scales,
%     subscripts = !is.null(groups), subset = TRUE)
% }
\usage{
qq(x, \dots)

\method{qq}{formula}(x, data = parent.frame(), aspect = "fill", 
    panel = panel.qq, prepanel, scales, strip, 
    groups, xlab, xlim, ylab, ylim, f.value = NULL, 
    drop.unused.levels = lattice.getOption("drop.unused.levels"),
    \dots,
    default.scales = list(),
    subscripts,
    subset)
}
\arguments{
  \item{x}{
    The object on which method dispatch is carried out.

    For the formula method, a formula of the form \code{y ~ x | g1 * g2
      * \ldots}, where \code{x} must be a numeric, and \code{y} can be a
    factor, shingle, character or numeric vector, with the restriction
    that there must be exactly two levels of \code{y}, which divide the
    values of \code{x} into two groups. Quantiles for these groups will
    be plotted along the two axes.
  }
  \item{data}{
    For the \code{formula} methods, an optional data frame in which
    variables in the formula (as well as \code{groups} and
    \code{subset}, if any) are to be evaluated.  By default, the
    environment where the function was called from is used.
  }
  \item{f.value}{ optional numeric vector of probabilities, quantiles
    corresponding to which should be plotted.  Can also be a function of
    a single integer (representing sample size) that returns such a
    numeric vector.  The typical value for this argument is the function
    \code{ppoints}, which is also the S-PLUS default.  If specified, the
    probabilities generated by this function is used for the plotted
    quantiles, using the \code{quantile} function.

    \code{f.value} defaults to \code{NULL}, which is equivalent to
    using \code{function(n) ppoints(n, a = 1)}. This has the effect of
    including the minimum and maximum data values in the computed
    quantiles. This is similar to what happens for \code{qqplot} but
    different from the default \code{qq} behaviour in S-PLUS.

    For large data, this argument can be useful in plotting a smaller
    set of quantiles, which is usually enough to capture the pattern.
  }
  \item{panel}{ The function that uses the packet (subset of display
    variables) corresponding to a panel to create a display.  Default
    panel functions are documented separately, and often have arguments
    that can be used to customize its display in various ways.  Such
    arguments can usually be directly supplied to the high level
    function.  }
  \item{aspect, prepanel, scales,
    strip, groups, xlab, xlim, ylab, ylim, drop.unused.levels,
    default.scales, subscripts, subset}{ See \code{\link{xyplot}} }
  \item{\dots}{
    Further arguments.  See corresponding entry in \code{\link{xyplot}}
    for non-trivial details.
  }
}
\value{

  An object of class \code{"trellis"}. The
  \code{\link[lattice:update.trellis]{update}} method can be used to
  update components of the object and the
  \code{\link[lattice:print.trellis]{print}} method (usually called by
  default) will plot it on an appropriate plotting device.

}
\author{Deepayan Sarkar \email{Deepayan.Sarkar@R-project.org}}
\details{
  \code{qq} produces a Q-Q plot of two samples.  The default behaviour
  of \code{qq} is different from the corresponding S-PLUS function. See
  the entry for \code{f.value} for specifics.

  This and all other high level Trellis functions have several
  arguments in common. These are extensively documented only in the
  help page for \code{xyplot}, which should be consulted to learn more
  detailed usage.
}

\seealso{\code{\link{xyplot}}, \code{\link{panel.qq}},
  \code{\link{qqmath}}, \code{\link{Lattice}}
}

\examples{
qq(voice.part ~ height, aspect = 1, data = singer,
   subset = (voice.part == "Bass 2" | voice.part == "Tenor 1"))
}
\keyword{dplot}




