% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmm2.R
\name{createContrast}
\alias{createContrast}
\alias{createContrast.list}
\title{Contrast matrix for multiple latent variable models}
\usage{
createContrast(object, ...)

\method{createContrast}{list}(object, coef.test = NULL, n.test = 0,
  var.test = NULL, ...)
}
\arguments{
\item{object}{a \code{ls.lvmfit} object.}

\item{...}{Only used by the generic method.}

\item{coef.test}{[optional] the name of the coefficients to be tested.
Each coefficient will be tested in a separate hypothesis.}

\item{n.test}{[optional] the number of linear hypotheses.}

\item{var.test}{[optional] a string appearing in each coeffcient to be tested.}
}
\description{
Returns an empty contrast matrix corresponding to a list of latent variable models.
}
\examples{
## Simulate data
mSim <- lvm(X ~ Age + Treatment,
            Y ~ Gender + Treatment,
            c(Z1,Z2,Z3) ~ eta, eta ~ treatment,
            Age[40:5]~1)
latent(mSim) <- ~eta
categorical(mSim, labels = c("placebo","SSRI")) <- ~Treatment
categorical(mSim, labels = c("male","female")) <- ~Gender
n <- 1e2
set.seed(10)
df.data <- sim(mSim,n)

## Estimate separate models
lmX <- estimate(lvm(X ~ -1 + Age + Treatment), data = df.data)
lmY <- estimate(lvm(Y ~ -1 + Gender + Treatment), data = df.data)
lvmZ <- estimate(lvm(c(Z1,Z2,Z3) ~ -1 + 1*eta, eta ~ -1 + Treatment), 
                 data = df.data)

## Contrast matrix for the join model
ls.lvm <- list(X = lmX, Y = lmY, Z = lvmZ)

createContrast(ls.lvm) 
createContrast(ls.lvm, var.test = "Treatment")

}
