% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareScore2.R
\name{prepareScore2}
\alias{prepareScore2}
\alias{prepareScore2.gls}
\alias{prepareScore2.lme}
\alias{prepareScore2<-}
\alias{prepareScore2<-.lvmfit}
\alias{prepareScore2.lvm}
\alias{prepareScore2.lvmfit}
\alias{prepareScore2<-}
\alias{prepareScore2<-.lvmfit}
\title{Prepare the Computation of score2}
\usage{
prepareScore2(object, ...)

\method{prepareScore2}{gls}(object, X, param, attr.param, second.order,
  n.cluster, n.endogenous, name.endogenous, index.obs, ...)

\method{prepareScore2}{lme}(object, X, param, attr.param, second.order,
  n.cluster, n.endogenous, name.endogenous, index.obs, ...)

prepareScore2(x, ...) <- value

\method{prepareScore2}{lvmfit}(x, ...) <- value

\method{prepareScore2}{lvm}(object, data, second.order,
  name.endogenous = NULL, name.latent = NULL, ...)

\method{prepareScore2}{lvmfit}(object, data = NULL, p = NULL,
  usefit = TRUE, name.endogenous = NULL, name.latent = NULL,
  second.order = FALSE, ...)

prepareScore2(x, ...) <- value

\method{prepareScore2}{lvmfit}(x, ...) <- value
}
\arguments{
\item{object, x}{a latent variable model.}

\item{...}{[internal] only used by the generic method or by the <- methods.}

\item{X}{[matrix] the design matrix.}

\item{param, p}{[numeric vector] the fitted coefficients.}

\item{attr.param}{[character vector] the type of each coefficient
(e.g. mean or variance coefficient).}

\item{second.order}{[logical] should the terms relative to the third derivative of the likelihood be be pre-computed?}

\item{n.cluster}{[integer >0] the number of i.i.d. observations.}

\item{n.endogenous}{[integer >0] the number of outcomes.}

\item{name.endogenous}{[character vector, optional] name of the endogenous variables}

\item{index.obs}{[integer vector] the indexes of the outcomes relative to each observation (e.g. 1,3 if only outcome 1 and 3 are observed for the observation).}

\item{data}{[data.frame, optional] data set.}

\item{name.latent}{[character vector, optional] name of the latent variables}

\item{usefit, value}{[logical] If TRUE the coefficients estimated by the model are used to pre-compute quantities. Only for lvmfit objects.}
}
\description{
Compute partial derivatives regarding to the mean and the variance, and compute the design matrices.
}
\details{
For lvmfit objects, there are two levels of pre-computation:
\itemize{
\item a basic one that do no involve the model coefficient
\item an advanced one that require the model coefficients. 
}
}
\examples{
prepareScore2 <- lavaSearch2:::prepareScore2

m <- lvm(Y1~eta,Y2~eta,Y3~eta)
latent(m) <- ~eta

e <- estimate(m, lava::sim(m,1e2))
res <- prepareScore2(e)
res$skeleton$df.param

}
\concept{
small sample inference

derivative of the score equation
}
\keyword{internal}
