% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-nlme.R
\name{getVarCov2}
\alias{getVarCov2}
\alias{getVarCov2.gls}
\alias{getVarCov2.lme}
\title{Reconstruct the Marginal Variance Covariance Matrix from a nlme Model}
\usage{
getVarCov2(object, ...)

\method{getVarCov2}{gls}(object, data = NULL, cluster, ...)

\method{getVarCov2}{lme}(object, data = NULL, cluster, ...)
}
\arguments{
\item{object}{a \code{gls} or \code{lme} object}

\item{...}{[internal] only used by the generic method.}

\item{data}{[data.frame] the data set.}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.}
}
\value{
A list containing the residual variance-covariance matrix in the element Omega.
}
\description{
Reconstruct the marginal variance covariance matrix from a nlme model.
Only compatible with specific correlation and variance structure. #'
}
\details{
The marginal variance covariance matrix for gls model is of the form:

\tabular{cccc}{
\eqn{\Sigma =} \tab \eqn{\sigma^2} \tab \eqn{\sigma^2 \sigma_2 \rho_{1,2}} \tab \eqn{\sigma^2 \sigma_3 \rho_{1,3}} \cr
\tab . \tab \eqn{\sigma^2 \sigma_2^2} \tab \eqn{\sigma^2 \sigma_3 \rho_{1,3}} \cr
\tab . \tab . \tab \eqn{\sigma^2 \sigma_3^2}
}
}
\examples{

## simulate data 
library(nlme)
n <- 5e1
mSim <- lvm(c(Y1~1*eta,Y2~1*eta,Y3~1*eta,eta~G))
latent(mSim) <- ~eta
transform(mSim,Id~Y1) <- function(x){1:NROW(x)}
set.seed(10)
dW <- lava::sim(mSim,n,latent = FALSE)
dW <- dW[order(dW$Id),,drop=FALSE]
dL <- reshape2::melt(dW,id.vars = c("G","Id"), variable.name = "time")
dL <- dL[order(dL$Id),,drop=FALSE]
dL$Z1 <- rnorm(NROW(dL))
dL$time.num <- as.numeric(as.factor(dL$time))

#### iid model #### 
e1.gls <- nlme::gls(Y1 ~ G, data = dW, method = "ML")
getVarCov2(e1.gls, cluster = 1:n)$Omega

#### heteroschedasticity ####
dW$group <- rbinom(n, size = 1, prob = 1/2)
dW$repetition <- as.numeric(as.factor(dW$group))
e2a.gls <- nlme::gls(Y1 ~ G, data = dW, method = "ML",
                    weights = varIdent(form =~ repetition|group))
getVarCov2(e2a.gls, cluster = 1:n)$Omega


e2b.gls <- nlme::gls(value ~ 0+time + time:G,
                   weight = varIdent(form = ~ time.num|time),
                   data = dL, method = "ML")
getVarCov2(e2b.gls, cluster = "Id")$Omega

#### compound symmetry ####
e3.gls <- nlme::gls(value ~ time + G,
                   correlation = corCompSymm(form = ~1| Id),
                   data = dL, method = "ML")
getVarCov2(e3.gls)$Omega

#### unstructured ####
e4.gls <- nlme::gls(value ~ time,
                    correlation = corSymm(form = ~time.num| Id),
                    weight = varIdent(form = ~ 1|time),
                    data = dL, method = "ML")
getVarCov2(e4.gls)$Omega

}
\concept{
extractor
}
