% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inside.R
\name{lawn_inside}
\alias{lawn_inside}
\title{Does a point reside inside a polygon}
\usage{
lawn_inside(point, polygon, lint = FALSE)
}
\arguments{
\item{point}{Input point}

\item{polygon}{Input polygon or multipolygon}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
\code{TRUE} if the Point IS inside the Polygon, \code{FALSE} if
the Point IS NOT inside the Polygon
}
\description{
Takes a \code{\link{data-Point}} and a \code{\link{data-Polygon}} or
\code{\link{data-MultiPolygon}} and determines if the point
resides inside the polygon
}
\details{
The polygon can be convex or concave. The function accounts for holes
}
\examples{
point1 <- '{
  "type": "Feature",
  "properties": {
    "marker-color": "#f00"
  },
  "geometry": {
    "type": "Point",
    "coordinates": [-111.467285, 40.75766]
  }
}'
point2 <- '{
  "type": "Feature",
  "properties": {
    "marker-color": "#0f0"
  },
  "geometry": {
    "type": "Point",
    "coordinates": [-111.873779, 40.647303]
  }
}'
poly <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Polygon",
    "coordinates": [[
      [-112.074279, 40.52215],
      [-112.074279, 40.853293],
      [-111.610107, 40.853293],
      [-111.610107, 40.52215],
      [-112.074279, 40.52215]
      ]]
  }
}'
lawn_inside(point1, poly)
lawn_inside(point2, poly)
}
\seealso{
Other joins: \code{\link{lawn_tag}},
  \code{\link{lawn_within}}
}

