% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midpoint.R
\name{lawn_midpoint}
\alias{lawn_midpoint}
\title{Get a point midway between two points}
\usage{
lawn_midpoint(pt1, pt2, lint = FALSE)
}
\arguments{
\item{pt1}{First point}

\item{pt2}{Second point}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
A \code{\link{data-Point}} midway between pt1 and pt2
}
\description{
Takes two \code{\link{data-Point}}'s and returns a point midway
between them
}
\examples{
pt1 <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Point",
    "coordinates": [144.834823, -37.771257]
  }
}'
pt2 <- '{
  "type": "Feature",
  "properties": {},
  "geometry": {
    "type": "Point",
    "coordinates": [145.14244, -37.830937]
  }
}'
lawn_midpoint(pt1, pt2)
}
\seealso{
Other measurements: \code{\link{lawn_along}},
  \code{\link{lawn_area}}, \code{\link{lawn_bbox_polygon}},
  \code{\link{lawn_bearing}}, \code{\link{lawn_center}},
  \code{\link{lawn_centroid}},
  \code{\link{lawn_destination}},
  \code{\link{lawn_distance}}, \code{\link{lawn_envelope}},
  \code{\link{lawn_extent}},
  \code{\link{lawn_line_distance}},
  \code{\link{lawn_point_on_surface}},
  \code{\link{lawn_size}}, \code{\link{lawn_square}}
}

