% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isolines.R
\name{lawn_isolines}
\alias{lawn_isolines}
\title{Generate Isolines}
\usage{
lawn_isolines(points, z, resolution, breaks, lint = FALSE)
}
\arguments{
\item{points}{Input points}

\item{z}{(character) the property name in points from which z-values will be pulled}

\item{resolution}{(numeric) resolution of the underlying grid}

\item{breaks}{(numeric) where to draw contours}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
\code{\link{data-FeatureCollection}} of isolines
(\code{\link{data-LineString}} features)
}
\description{
Takes \code{\link{data-Point}}'s with z-values and an array of value
breaks and generates \href{http://en.wikipedia.org/wiki/Isoline}{isolines}
}
\examples{
pts <- lawn_random(n = 100, bbox = c(0, 30, 20, 50))
pts$features$properties <- data.frame(z = round(rnorm(100, mean = 5)), stringsAsFactors = FALSE)
breaks <- c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
lawn_isolines(pts, 'z', 15, breaks)

}
\seealso{
Other interpolation: \code{\link{lawn_hex_grid}},
  \code{\link{lawn_planepoint}},
  \code{\link{lawn_point_grid}},
  \code{\link{lawn_square_grid}}, \code{\link{lawn_tin}},
  \code{\link{lawn_triangle_grid}}
}

