% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_grid.R
\name{lawn_point_grid}
\alias{lawn_point_grid}
\title{Create a PointGrid}
\usage{
lawn_point_grid(extent, cellWidth, units)
}
\arguments{
\item{extent}{(numeric) extent in [minX, minY, maxX, maxY] order}

\item{cellWidth}{(integer) width of each cell}

\item{units}{(character) units to use for cellWidth, one of 'miles' or
'kilometers'}
}
\value{
\code{\link{data-FeatureCollection}} grid of points
}
\description{
Takes a bounding box and a cell depth and returns a set of
\code{\link{data-Point}}'s in a grid
}
\examples{
lawn_point_grid(c(-77.3876, 38.7198, -76.9482, 39.0277), 30, 'miles')
lawn_point_grid(c(-77.3876, 38.7198, -76.9482, 39.0277), 10, 'miles')
lawn_point_grid(c(-77.3876, 38.7198, -76.9482, 39.0277), 3, 'miles')
}
\seealso{
Other interpolation: \code{\link{lawn_hex_grid}},
  \code{\link{lawn_isolines}},
  \code{\link{lawn_planepoint}},
  \code{\link{lawn_square_grid}}, \code{\link{lawn_tin}},
  \code{\link{lawn_triangle_grid}}
}

