% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissolve.R
\name{lawn_dissolve}
\alias{lawn_dissolve}
\title{Dissolves a FeatureCollection of polygons based on a property. Note
that multipart features within the collection are not supported}
\usage{
lawn_dissolve(features, key, lint = FALSE)
}
\arguments{
\item{features}{A \link{data-FeatureCollection}<(\link{data-Polygon})>}

\item{key}{(character) The property on which to filter}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a \link{data-FeatureCollection}<(\link{data-Polygon})> containing the
dissolved polygons
}
\description{
Dissolves a FeatureCollection of polygons based on a property. Note
that multipart features within the collection are not supported
}
\examples{
cat(lawn_data$filter_features)
x <- '{
 "type": "FeatureCollection",
 "features": [
  {
    "type": "Feature",
    "properties": {
      "combine": "yes"
    },
    "geometry": {
      "type": "Polygon",
      "coordinates": [[[0, 0], [0, 1], [1, 1], [1, 0], [0, 0]]]
    }
  },
  {
    "type": "Feature",
    "properties": {
      "combine": "yes"
    },
    "geometry": {
      "type": "Polygon",
      "coordinates": [[[0, -1], [0, 0], [1, 0], [1, -1], [0,-1]]]
    }
  },
  {
    "type": "Feature",
    "properties": {
      "combine": "no"
    },
    "geometry": {
      "type": "Polygon",
      "coordinates": [[[1,-1],[1, 0], [2, 0], [2, -1], [1, -1]]]
    }
  }
  ]
}'
lawn_dissolve(x, key = 'combine')
}
\seealso{
Other assertions: \code{\link{lawn_circle}},
  \code{\link{lawn_tesselate}}
}
