% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ast.R
\name{ast_}
\alias{ast}
\alias{ast_}
\title{Display a call (or expression) as a tree.}
\usage{
ast_(x, width = getOption("width"))

ast(x)
}
\arguments{
\item{x}{Quoted call, list of calls, or expression to display.}

\item{width}{Display width, defaults to current width as reported by
\code{getOption("width")}.}
}
\description{
\code{ast_} takes a quoted expression; \code{ast} does the quoting
for you.
}
\examples{
ast(f(x, 1, g(), h(i())))
ast(if (TRUE) 3 else 4)
ast(function(a = 1, b = 2) {a + b + 10})
ast(f(x)(y)(z))

ast_(quote(f(x, 1, g(), h(i()))))
ast_(quote(if (TRUE) 3 else 4))
ast_(expression(1, 2, 3))
}

