% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f-eval.R
\name{f_eval_rhs}
\alias{f_eval}
\alias{f_eval_lhs}
\alias{f_eval_rhs}
\alias{find_data}
\title{Evaluate a formula}
\usage{
f_eval_rhs(f, data = NULL)

f_eval_lhs(f, data = NULL)

f_eval(f, data = NULL)

find_data(x)
}
\arguments{
\item{f}{A formula. Any expressions wrapped in \code{ uq() } will
will be "unquoted", i.e. they will be evaluated, and the results inserted
back into the formula. See \code{\link{f_interp}} for more details.}

\item{data}{A list (or data frame). \code{find_data} is a generic used to
find the data associated with a given object. If you want to make
\code{f_eval} work for your own objects, you can define a method for this
generic.}

\item{x}{An object for which you want to find associated data.}
}
\description{
\code{f_eval_rhs} evaluates the RHS of a formula and \code{f_eval_lhs}
evaluates the LHS. \code{f_eval} is a shortcut for \code{f_eval_rhs} since
that is what you most commonly need.
}
\details{
If \code{data} is specified, variables will be looked for first in this
object, and if not found in the environment of the formula.
}
\section{Pronouns}{

When used with \code{data}, \code{f_eval} provides two pronouns to make it
possible to be explicit about where you want values to come from:
\code{.env} and \code{.data}. These are thin wrappers around \code{.data}
and \code{.env} that throw errors if you try to access non-existent values.
}
\examples{
f_eval(~ 1 + 2 + 3)

# formulas automatically capture their enclosing environment
foo <- function(x) {
  y <- 10
  ~ x + y
}
f <- foo(1)
f
f_eval(f)

# If you supply data, f_eval will look their first:
f_eval(~ cyl, mtcars)

# To avoid ambiguity, you can use .env and .data pronouns to be
# explicit:
cyl <- 10
f_eval(~ .data$cyl, mtcars)
f_eval(~ .env$cyl, mtcars)

# Imagine you are computing the mean of a variable:
f_eval(~ mean(cyl), mtcars)
# How can you change the variable that's being computed?
# The easiest way is "unquote" with uq()
# See ?f_interp for more details
var <- ~ cyl
f_eval(~ mean( uq(var) ), mtcars)
}

