% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_labelled_data.R
\name{create_labelled_data}
\alias{create_labelled_data}
\title{Create labelled data}
\usage{
create_labelled_data(x, n = 50, type = "regression")
}
\arguments{
\item{x}{- data set containing a table where 1st column is a Time index and other columns containing financial asset price values}

\item{n}{- number of rows we intend to split and transpose the data to}

\item{type}{- type of the label required. Can be either "classification" or "regression".
"classification" will return either "BU" or "BE",
"regression" will return the difference between first value and the last value in each row (in pips)}
}
\value{
function returns transposed data. One column called 'LABEL' indicate achieved value of the label.
Transposed values from every column are stacked one to each other
}
\description{
FUNCTION create_labelled_data.
PURPOSE: function gets price data of every currency in each column.
It is splitting this data by periods and transposes the data.
Additionally function is capable to label the data based on the simple logic.
Each row will be assigned into 2 categories based on the difference between beginning and end of the row elements
Finally all data will be stacked on top and joined into the table

Learn by example how to manipulate data
}
\details{
see more info in the udemy course self-learning-trading-robot
}
\examples{


library(tidyverse)

# usind a sample data
data(price_dataset)

# price change as a label
create_labelled_data(price_dataset, n = 75, type = "regression")

# factors 'BU'/'BE' as a label
create_labelled_data(price_dataset, n = 75, type = "classification")


}
