% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/self_learn_ai_R.R
\name{self_learn_ai_R}
\alias{self_learn_ai_R}
\title{Function to train Deep Learning regression model}
\usage{
self_learn_ai_R(
  price_dataset,
  indicator_dataset,
  num_bars,
  timeframe,
  path_model,
  setup_mode = FALSE,
  research_mode = FALSE,
  write_log = TRUE
)
}
\arguments{
\item{price_dataset}{Dataset containing assets prices. It will be used as a label}

\item{indicator_dataset}{Dataset containing assets indicator which pattern will be used as predictor}

\item{num_bars}{Number of bars used to detect pattern}

\item{timeframe}{Data timeframe e.g. 1 min}

\item{path_model}{Path where the models are be stored}

\item{setup_mode}{When TRUE function will attempt to write model to the disk without checking it}

\item{research_mode}{When TRUE model will be saved and model result will be stored as well. To be used at the first run.}

\item{write_log}{Writes results of the newly trained model and previously used model to the file}
}
\value{
Function is writing files into Decision Support System folder
}
\description{
Function is training h2o deep learning model to match future prices of the asset to the indicator pattern.
Main idea is to be able to predict future prices by solely relying on the most recent indicator pattern.
}
\details{
Performs data manipulation and training of the model. Function is handling shift of the price and indicator datasets.
Function will also check how the model predict by using trading objective.
NOTE: Always run parameter research_mode = TRUE for the first time

Because of the function is intended to periodically re-train the model it would always check how the previous model was working.
In case new model is better, the better model will be used.

Function can also write a log files with a results of the strategy test
}
\examples{

\donttest{

library(dplyr)
library(readr)
# start h2o engine (using all CPU's by default)
h2o.init()

# performing Deep Learning Regression using the custom function
self_learn_ai_R(price_dataset = prices,
                indicator_dataset = macd,
                num_bars = 75,
                timeframe = 1,
                path_model = path_model,
                write_log = TRUE)

# stop h2o engine
h2o.shutdown(prompt = F)

}



}
\author{
(C) 2019 Vladimir Zhbanko
}
