% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_asset_data.R
\name{load_asset_data}
\alias{load_asset_data}
\title{Load and Prepare Asset Data}
\usage{
load_asset_data(
  path_terminal,
  trade_log_file,
  time_period = 1,
  data_deepth = 50000
)
}
\arguments{
\item{path_terminal}{\itemize{
\item path to the MT4 terminal, string
}}

\item{trade_log_file}{\itemize{
\item csv file name where the data is stored, without ".csv"
}}

\item{time_period}{\itemize{
\item data periodicity in minutes, can be 1, 15, 60
}}

\item{data_deepth}{\itemize{
\item collected data deepth in rows. describe how many rows in original file to read
}}
}
\value{
\itemize{
\item dataframe with asset data in columns where X1 column is in a POSIXct format
}
}
\description{
Function imports file with financial asset data. Each column represent one asset, rows represent observations.
Values in specific columns will be normalized by dividing them by 100. This is specifically done for pairs with JPY.
In addition, X1 column will be converted to the ymd_hms format

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
Works for both price and indicator values, function parameters allowing to import different files.
File names are selected to account different time periodicity and amount of the data
}
\examples{

library(readr)
library(dplyr)
library(lubridate)
library(magrittr)
path_terminal <- system.file("extdata", package = "lazytrade")

# load and prepare prices data
prices <- load_asset_data(path_terminal = path_terminal,
                          trade_log_file = "AI_CP",
                          time_period = 60,
                          data_deepth = "300")

# load and prepare indicator data
macd <- load_asset_data(path_terminal = path_terminal,
                        trade_log_file = "AI_Macd",
                        time_period = 60,
                        data_deepth = "300")


}
