% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_evaluate.R
\name{mt_evaluate}
\alias{mt_evaluate}
\title{Function to score data and predict current market type using pre-trained classification model}
\usage{
mt_evaluate(x, path_model, num_cols, timeframe)
}
\arguments{
\item{x}{\itemize{
\item dataframe with one column containing asset indicator in the time descending order,
typically 64 or more values
}}

\item{path_model}{String, path to the model}

\item{num_cols}{Integer, number of columns (features) in the final vector input to the model}

\item{timeframe}{Integer, timeframe in Minutes.}
}
\value{
dataframe with predicted value of the market type
}
\description{
PURPOSE: Function that uses Deep Learning model and Time Series Column of the dataframe
to find out specific market type of the financial asset
it will also discard bad result outputting -1 if it is the case
}
\details{
it is mandatory to switch on the virtual h2o machine with h2o.init()
also to shut it down with h2o.shutdown(prompt = F)
}
\examples{

\donttest{

library(h2o)
library(magrittr)
library(dplyr)
library(readr)
library(lazytrade)

path_model <- normalizePath(tempdir(),winslash = "/")
path_data <- normalizePath(tempdir(),winslash = "/")

data(macd_ML60M)

# start h2o engine (using all CPU's by default)
h2o.init(nthreads = 2)

# performing Deep Learning Regression using the custom function
# this function stores model to the temp location
mt_make_model(indicator_dataset = macd_ML60M,
              num_bars = 64,
              timeframe = 60,
              path_model = path_model,
              path_data = path_data,
              activate_balance = TRUE,
              num_nn_options = 3)


# Use sample data
data(macd_100)

# use one column for testing
x <- macd_100[ ,2]


mt_evaluate(x = x,
            path_model = path_model,
            num_cols = 64,
            timeframe = 60)

h2o.shutdown(prompt = FALSE)

#set delay to insure h2o unit closes properly before the next test
Sys.sleep(5)

}

}
