% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_command_via_csv.R
\name{write_command_via_csv}
\alias{write_command_via_csv}
\title{Write csv files with indicated commands to the external system}
\usage{
write_command_via_csv(x, path_terminal = "", fileName = "SystemControl")
}
\arguments{
\item{x}{\itemize{
\item dataframe object with resulting command e.g. 1 - enable; 0 - disable
}}

\item{path_terminal}{\itemize{
\item path to the terminal
}}

\item{fileName}{\itemize{
\item desired control file prefix e.g. 'SystemControl'
}}
}
\value{
Function is writing multiple files e.g. 'SystemControl8139124.csv' to the Sandbox

typical content of the file:
"Magic","IsEnabled"
8139124,1
}
\description{
Function is capable to read the data and  writing multiple files
e.g. 'SystemControl8139124.csv'

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{

library(dplyr)
library(readr)
library(lubridate)
library(lazytrade)

path_sbxm <- normalizePath(tempdir(),winslash = "/")

file.copy(from = system.file("extdata", "OrdersResultsT1.csv", package = "lazytrade"),
          to = file.path(path_sbxm, "OrdersResultsT1.csv"), overwrite = TRUE)

DFT1 <- import_data(path_sbxm = path_sbxm,
                    trade_log_file = "OrdersResultsT1.csv")

DFT1 \%>\%
group_by(MagicNumber) \%>\% select(MagicNumber) \%>\% mutate(IsEnabled = 0) \%>\%
# head to shorten time of this example
head(2) \%>\%
# write commands to disable/enable systems
write_command_via_csv(path_terminal = path_sbxm)




}
\author{
(C) 2019, 2021 Vladimir Zhbanko
}
