% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lboxcox.R
\name{lbc_train}
\alias{lbc_train}
\title{Train a Logistic Box-Cox model}
\usage{
lbc_train(
  formula,
  weight_column_name,
  data,
  init = NULL,
  svy_lambda_vector = seq(0, 2, length = 100),
  num_cores = 1
)
}
\arguments{
\item{formula}{a formula of the form y ~ x + z1 + z2 where y is a binary response variable, x is a continuous predictor variable, and z1, z2, ... are  covariates}

\item{weight_column_name}{the name of the column in `data` containing the survey weights.}

\item{data}{dataframe containing the dataset to train on}

\item{init}{initial estimates for the coefficients. If NULL the svyglm model will be used}

\item{svy_lambda_vector}{values of lambda used in training svyglm model. Best model is used for initial coefficient estimates. If init is not NULL this parameter is ignored.}

\item{num_cores}{the number of cores used when finding the best svyglm model. If init is not NULL this parameter is ignored.}
}
\value{
object of class 'maxLik' from the 'maxLik' package. Contains the coefficient estimates that maximizes likelhood among other statistics.
}
\description{
Train the given formula using a Logistic Box-Cox model.
}
\note{
This is reliant on the following work:

Henningsen, A., Toomet, O. (2011). maxLik: A package for maximum likelihood estimation in R. Computational Statistics, 26(3), 443-458.

Microsoft Corporation, Weston, S. (2020). foreach: Provides Foreach Looping Construct. R package version 1.5.1.

Microsoft Corporation, Weston, S. (2020). doParallel: Foreach Parallel Adaptor for the 'parallel' Package. R package version 1.0.16.
}
