\name{predictY}
\alias{predictY}
\alias{predictY.lcmm}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Predicted values of a \code{lcmm} object in the natural scale of the outcome for a specified profile of covariates.
}
\description{
Provides predicted values of a \code{lcmm} object in the natural scale of the outcome for a specified profile of covariates. For linear and threshold links, the predicted values are computed analytically. For splines and Beta links, a Gauss-Hermite or Monte-Carlo integration are used to numerically compute the predictions. In addition, for any type of link function, confidence bands (and median) can be computed by a Monte Carlo approximation of the posterior distribution of the predicted values.
}
\usage{
\method{predictY}{lcmm}(x,newdata,methInteg=0,nsim=20,draws=FALSE,ndraws=2000,na.action=1,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
an object inheriting from class \code{lcmm} representing a general latent class mixed model.
}
  \item{newdata}{
data frame containing the data from which predictions are computed. Data frame should include all the covariates listed in x$Xnames2. Names of data frame should be exactly x$Xnames2 that is the names of covariates specified in \code{lcmm} call.
}
  \item{methInteg}{
optional integer specifying the type of numerical integration required only for predictions with splines or Beta link functions. Value 0 (by default) specifies a Gauss-Hermite integration which is very rapid but neglects the correlation between the predicted values (in presence of random-effects). Value 1 refers to a Monte-Carlo integration which is slower but correctly account for the correlation between the predicted values.
}
  \item{nsim}{
  optional number of points used in the integration method for predictions with splines or Beta link functions. For methInteg=1, nsim should be chosen among the following values: 5, 7, 9, 15, 20, 30, 40 or 50 (nsim=20 by default). If methInteg=0, nsim should be relatively important (more than 200).
}
  \item{draws}{
  optional boolean specifying whether median and confidence bands of the predicted values should be computed (TRUE) - whatever the type of link function. In this case, a Monte Carlo approximation of the posterior distribution of the predicted values is computed and the median, 2.5% and 97.5% percentiles are given. Otherwise, the predicted values are computed at the point estimate. By default, draws=FALSE.  
}
  \item{ndraws}{
  If draws=TRUE, ndraws specifies the number of draws that should be generated to approximate the posterior distribution of the predicted values. By default, ndraws=2000.
}
 \item{na.action}{
Integer indicating how NAs are managed. The default is 1 for 'na.omit'. The alternative is 2 for 'na.fail'. Other options such as 'na.pass' or 'na.exclude' are not implemented in the current version.}
  \item{\dots}{
further arguments to be passed to or from other methods.
          They are ignored in this function.
}
}
\value{
Returns a matrix with ng columns when draws=FALSE corresponding to the ng class-specific vectors of predicted values computed at the point estimate or a matrix with ng*3 columns representing the ng class-specific 2.5\%, 50\% and 97.5\% (median) percentiles of the approximated posterior distribution of the class-specific predicted values.
}
\author{
Cecile Proust-Lima
}
\seealso{
\code{\link{lcmm}}, \code{\link{plot.lcmm}}
}
\examples{

################# Prediction from a 2-class model with a Splines link function

data(data_Jointlcmm)
## fitted model
m<-lcmm(Ydep2~Time*X1,mixture=~Time,random=~Time,classmb=~X2+X3,
subject='ID',ng=2,data=data_Jointlcmm,link="splines",B=c(
-0.175,      -0.191,       0.654,      -0.443, 
-0.345,      -1.780,       0.913,       0.016, 
 0.389,       0.028,       0.083,      -7.349, 
 0.722,       0.770,       1.376,       1.653, 
 1.640,       1.285))
m
## predictions for times from 0 to 5 for X1=0
newdata<-data.frame(Time=seq(0,5,length=100),
X1=rep(0,100),X2=rep(0,100),X3=rep(0,100))
predictY(m,newdata)
## Option draws=TRUE to compute a MonteCarlo 
# approximation of the predicted value distribution 
# (quite long with ndraws=2000 by default)
\dontrun{
predictY(m,newdata,draws=TRUE)
}
## predictions for times from 0 to 5 for X1=1
newdata$X1 <- 1
predictY(m,newdata)
## Option draws=TRUE to compute a MonteCarlo 
# approximation of the predicted value distribution 
# (quite long with ndraws=2000 by default)
\dontrun{
predictY(m,newdata,draws=TRUE)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
