# Purpose : Wald test statistic
# Program : WaldMult fonction (fonction2.R)
# Author : Lionelle Nkam
# Date : 07 June 2013
# Reviewer : Ccile Proust-Lima

WaldMult<-function(Mod,pos=NULL,contrasts=NULL,name=NULL,value=NULL)
{ 
  # Le paramtre Mod doit tre du type hlme du package lcmm
  if (class(Mod)%in%c("hlme","lcmm","multlcmm","Jointlcmm")) {}
  else  {stop("applies to \"hlme\" or \"lcmm\" or \"multlcmm\" or \"Jointlcmm\" objects only")}
    
  
#  nea<-sum(Mod$idea) # Nombre d'effets alatoires
#  nef<-Mod$N[2]      # Nombre d'effets fixes
#  nvc<-Mod$N[3]      # Nombre de paramtres de la partie triangulaire infrieure de la matrice B de variance-covariance des effets alatoires
#  nprob<-Mod$N[1]

  if(inherits(Mod,"hlme") | inherits(Mod,"lcmm"))
  {
   nea<-sum(Mod$idea) # Nombre d'effets alatoires
   nef<-Mod$N[2]      # Nombre d'effets fixes
   nvc<-Mod$N[3]      # Nombre de paramtres de la partie triangulaire infrieure de la matrice B de variance-covariance des effets alatoires
   nprob<-Mod$N[1]
   idiag <- ifelse(Mod$idiag==1,TRUE,FALSE)
  }
  if(inherits(Mod,"multlcmm"))
  {
   nea <- sum(Mod$idea0)
   nef <- Mod$N[3]
   nvc <- Mod$N[4]
   nprob <- 0 #nef contient deja nprob
   idiag <- ifelse(Mod$idiag==1,TRUE,FALSE)
  }
  
  if(inherits(Mod,"Jointlcmm"))
  {
   N <- Mod$specif[[1]]
   nea <- sum(Mod$specif[[4]])
   nef <- N[4]
   nvc <- N[5]
   nprob <- 0 #nef contient deja nprob
   idiag <- ifelse(Mod$specif[[8]]==1,TRUE,FALSE)
  }

  
  # On remplace les varcov de $best par les paramtres de cholesky
  if(nvc>0)
  {   
   debut <- nprob+nef+1
   fin <- nprob+nef+nvc
   cholesky <- Mod$cholesky
   if(inherits(Mod,"multlcmm")) cholesky[1] <- NA

   if(isTRUE(idiag)) cholesky[setdiff(1:(nea*(nea+1)/2),1:nea*(1:nea+1)/2)] <- NA
   
   Mod$best[debut:fin] <- na.omit(cholesky)
  }
  
  # On rend symtrique la matrice des varcov des paramtres estims par le modle
  l <- length(Mod$best)
  V <- matrix(0,nrow=l,ncol=l)
  V[upper.tri(V,diag=TRUE)] <- Mod$V  
  V[lower.tri(V,diag=FALSE)] <- t(V)[lower.tri(V,diag=FALSE)]
  
  # On teste si pos est un vecteur
  if (is.vector(pos)==F) {stop("Error : pos must be a numeric vector")}
  if (is.null(pos)==T) {stop("pos must be specified")}
  else {
    
    # On cree la matrice qui recevra les varcov des paramtres de pos
    Mat <- matrix(0,nrow=length(pos),ncol=length(pos))
    
    # Remplissage de Mat sans boucles
    Mat <- V[pos,pos]
            
    # Wald Multivari, sans le vecteur contrasts
    Vect <- Mod$best[pos]
    
    
    if (is.null(contrasts)==T){ 
             
      if (is.null(value)==F)
      { if (is.vector(value)==F) {stop("Error : value must be a numeric vector")}
        if (length(value)!=length(pos)) {stop("value must have the same length as the vector pos")}  
        
        Vect <- Mod$best[pos]-value
      }
      
      
      Wald <- t(Vect)%*%solve(Mat)%*%Vect
      
      # Nombre de degr de libert
      ddl <- length(pos)
      # Pvalue
      p_value <- 1-pchisq(Wald,df=ddl)
      #cat("pvalue",p_value1,"\n")
      
      Results <- matrix(NA,nrow=1,ncol=2)
      colnames(Results)<-c("Wald Test","p_value")
      if (is.null(name)==T) 
        {if (is.null(value)==F)
          {rownames(Results)<-paste(names(Mod$best[pos])," = ",value,collapse=" and ",sep="")}
          else {rownames(Results)<-paste(paste(names(Mod$best[pos]),collapse=" = "),"= 0")}
      }
      # paste(names(Mod$best[pos])," = 0 ",collapse=" and ",sep="")} 
      else {rownames(Results)<-name}
      
      Results[,1] <- round(Wald,5)
      Results[,2] <- round(p_value,5)
    }
    
    # Wald Univari avec le vecteur contrasts
    else {
      # Conditions d'application
      if (length(contrasts)!=length(pos))
      {stop("contrasts must have the same length as the vector pos")} 
      if (sum(abs(contrasts))==0) 
      {stop("The absolute value of the sum of contratsts components must be different from 0")}
      
            
      # Utilisation de value
      #if (is.null(value)==T)
      #{ 
        Scalaire <- sum(Vect*contrasts)
      #}
      #else
      if (is.null(value)==F)
      { if (is.vector(value)==F) {stop("Error : value must be a numeric vector")}
        if (length(value)!=1) {stop("value must be a vector with a unique argument")}  
        
        Scalaire <- sum(Vect*contrasts)-value
      }
 
      # Calcul de la variance de scalaire sans boucle
      Var <- t(contrasts)%*%Mat%*%contrasts
      
      
      Wald <- Scalaire/sqrt(Var)
      p_value <- 2*(1-pnorm(abs(Wald)))
      
      Results <- matrix(NA,nrow=1,ncol=4)
      colnames(Results)<-c("coef","Se","Wald Test","p_value")
      if (is.null(name)==T) 
      {
       if(is.null(value)) value <- 0
       rownames(Results)<-paste(paste(names(Mod$best[pos]),"*",contrasts,collapse=" + "),"= ",value)
      } 
      else {rownames(Results)<-name}
      
            
      Results[,1] <- round(sum(Vect*contrasts),5)
      Results[,2] <- round(sqrt(Var),5)
      Results[,3] <- round(Wald,5)
      Results[,4] <- round(p_value,5)
    }
    
    return(Results)
    
  }  
}


