% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{.internally_compare_ldamatch_outputs}
\alias{.internally_compare_ldamatch_outputs}
\title{Compares outputs of ldamatch runs using internally normalized parameters.}
\usage{
.internally_compare_ldamatch_outputs(
  is.in1,
  is.in2,
  condition,
  covariates,
  halting_test,
  props,
  prefer_test,
  tiebreaker
)
}
\arguments{
\item{is.in1}{A logical vector for output 1, TRUE iff row is in the match.}

\item{is.in2}{A logical vector for output 2, TRUE iff row is in the match.}

\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A columnwise matrix containing
covariates to match the conditions on.}

\item{halting_test}{A function to apply to `covariates` (in matrix form)
which is TRUE iff the conditions are matched.
Signature: halting_test(condition, covariates, thresh).
The following halting tests are part of this package:
\code{\link{t_halt}}, \code{\link{U_halt}},
\code{\link{l_halt}}, \code{\link{ad_halt}},
\code{\link{ks_halt}}, \code{\link{wilks_halt}},
\code{\link{f_halt}}.
You can create the intersection of two or more halting
tests using \code{\link{create_halting_test}}.}

\item{props}{Either the desired proportions (percentage) of the
sample for each condition as a named vector,
or the names of the conditions
for which we prefer to preserve the subjects,
in decreasing order of preference. If not specified, the
(full) sample proportions are used.
This is preferred among configurations with the same
taken into account by the other methods to some extent.
For example, c(A = 0.4, B = 0.4, C = 0.2) means that
we would like the number of subjects in groups A, B, and
C to be around 40\%, 40\%, and 20\% of the total number of
subjects, respectively. Whereas c("A", "B", "C") means
that if possible, we would like to keep all subjects
in group A, and prefer keeping subjects in B, even if
it results in losing more subjects from C.}

\item{prefer_test}{If TRUE, it prioritizes the test statistic more than
the group size proportion.}

\item{tiebreaker}{NULL, or a function similar to halting_test, used to
decide between cases for which halting_test yields
equal values.}
}
\value{
A number that is > 0 if is.in1 is a better solution than is.in2,
        < 0 if is.in1 is a worse solution than is.in2, or
        0 if the two solutions are equivalent (not necessarily identical).
}
\description{
Compares outputs of ldamatch runs using internally normalized parameters.
}
\seealso{
\code{\link{compare_ldamatch_outputs}} for operation and meaning of
parameters.
}
\keyword{internal}
