% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCR.R
\name{PCR_ensemble_selection}
\alias{PCR_ensemble_selection}
\title{Select the best reconstruction}
\usage{
PCR_ensemble_selection(
  Qa,
  pc,
  start.year,
  transform = "log",
  Z = NULL,
  agg.type = c("best member", "best overall"),
  criterion = c("RE", "CE", "nRMSE", "KGE"),
  return.all.metrics = FALSE
)
}
\arguments{
\item{Qa}{Observations: a data.frame of annual streamflow with at least two columns: year and Qa.}

\item{pc}{For a single model: a data.frame, one column for each principal component. For an ensemble reconstruction: a list, each element is a data.frame of principal components.}

\item{start.year}{Starting year of the climate proxies, i.e, the first year of the paleo period. \code{start.year + nrow(pc) - 1} will determine the last year of the study horizon, which must be greater than or equal to the last year in \code{Qa}.}

\item{transform}{Flow transformation, either "log", "boxcox" or "none". Note that if the Box-Cox transform is used, the confidence interval after back-transformation is simply the back-transform of the trained onfidence interval; this is hackish and not entirely accurate.}

\item{Z}{A list of cross-validation folds. If \code{NULL}, will be created with \code{make_Z()} with default settings. Users are advised to use \code{make_Z()} to create the cross-validation folds beforehand. See \link{make_Z} for details.}

\item{agg.type}{Type of ensemble aggregate. There are 2 options: 'best member': the member with the best performance score is used; 'best overall': if the ensemble average is better than the best member, it will be used, otherwise the best member will be used.}

\item{criterion}{The performance criterion to be used.}

\item{return.all.metrics}{Logical, if TRUE, all members' performance scores (and the ensemble average's score, if \code{agg.type == 'best overall'}) are returned.}
}
\value{
A list of two elements:
\itemize{
\item choice: The index of the selection. If the ensemble is selected, returns 0.
\item cv: the cross-validation results of the choice, see \link{cvPCR} for details.
\item all.metrics: all members' scores, and if \code{agg.type == 'best overall'}, the ensemble average's scores as well, in the last column.
}
}
\description{
Select the best reconstruction from an ensemble. Experimental, API may change.
}
\examples{
PCR_ensemble_selection(NPannual, list(NPpc, NPpc[, 1:2]), start.year = 1200,
                       agg.type = 'best overall', criterion = 'KGE')
PCR_ensemble_selection(NPannual, list(NPpc, NPpc[, 1:2]), start.year = 1200,
                       agg.type = 'best overall', criterion = 'KGE')
}
