\encoding{UTF-8}
\name{toGeoJSON}
\alias{toGeoJSON}
\alias{tg}
\title{Create GeoJSON file from data frame or external spatial data file}
\description{Creates a GeoJSON file from a data frame or a spatial data file, using the Ogre web API.}
\usage{
toGeoJSON(data, name, dest, lat.lon)
tg(data, name, dest, lat.lon)
}
\arguments{
  \item{data}{\code{\link{data.frame}} with at least two columns, representing the point coordinates. Or: Path to external spatial data file (see details below), as string.}
  \item{name}{Name of the resulting GeoJSON file, as string. Optional -- if missing, the name of the data frame or data file is used.}
  \item{dest}{Directory the file shall be saved to, as string. Optional -- if missing, the current working directory is used.}
  \item{lat.lon}{For data frame conversion only. Names or indices of the columns in \code{data} containing the coordinates, as vector of two: \code{c(latitude, longitude)}. Optional -- if missing, the first two columns are used.}
}
\details{\emph{Conversion of external spatial data files}

\code{toGeoJSON} uses the Ogre web API (\url{http://ogre.adc4gis.com}). Ogre accepts the following file types directly: .bna, .csv, .dgn, .dxf, .gxt, .txt, .rss, .georss, .xml, .gmt, .kml and .kmz. Please note that for Shapefiles, GML, MapInfo, and VRT, Ogre only accepts a zip file. The Ogre API does not support large files (>15 MB). Have a look at the \code{rgdal} package and its \code{writeOGR} function, to convert files on your local machine.
}
\value{GeoJSON file path, as string.}
\source{The code for the conversion of external data files is taken from the \code{togeojson} function of the \code{rgbif} package (\url{http://cran.r-project.org/web/packages/rgbif}). Package import would have unreasonably increased the dependencies of \code{leafletR}.}
\author{Christian Graul}
\seealso{\code{\link{leaflet}}}
\examples{
\dontrun{
# convert data frame
data(quakes)
toGeoJSON(data=quakes, name="quakes", dest=tempdir(), lat.lon=c(1,2))

# convert data frame - minimal call
# storing output file path in variable
data(quakes)
path <- toGeoJSON(data=quakes)

# convert a shapefile (in zipped archive)
toGeoJSON(data=system.file(package="leafletR", "files", "park_sk.zip"), 
  name="NatParks_SK", dest=tempdir())

# convert a DXF file
# storing output file path in variable
path <- toGeoJSON(data=system.file(package="leafletR", "files", 
  "lynx.dxf"), name="lynx_telemetry", dest=tempdir())

# convert a KML file
# using name of data file and saving to working directory
toGeoJSON(system.file(package="leafletR", "files", "peak_sk.kml"))
}
}
\keyword{methods}