% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer_validation.R
\name{buffer_validation}
\alias{buffer_validation}
\title{Calculate the similarity of a least-cost path to a known route}
\usage{
buffer_validation(lcp, comparison, dist)
}
\arguments{
\item{lcp}{\code{sf} or \code{spatVector}}

\item{comparison}{\code{sf} or \code{spatVector}}

\item{dist}{\code{numeric} buffer distances to assess similarity}
}
\value{
\code{data.frame}
}
\description{
Calculates the similarity of a least-cost path to a known route using the buffer method proposed by Goodchild and Hunter (1997)
}
\examples{

r <- terra::rast(system.file("extdata/SICILY_1000m.tif", package="leastcostpath"))

slope_cs <- create_slope_cs(x = r, cost_function = "tobler", neighbours = 4)

locs <- sf::st_sf(geometry = sf::st_sfc(
sf::st_point(c(839769, 4199443)),
sf::st_point(c(1038608, 4100024)),
crs = terra::crs(r)))

lcp1 <- create_lcp(x = slope_cs, origin = locs[1,], destination = locs[2,])

lcp2 <- create_lcp(x = slope_cs, origin = locs[2,], destination = locs[1,])

buffer_validation(lcp = lcp1, comparison = lcp2, dist = c(1000, 2500, 5000, 10000))
}
\author{
Joseph Lewis
}
