% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cond_hmpm}
\alias{cond_hmpm}
\title{Extract Conditional Ahistorical Matrices from Historical MPM}
\usage{
cond_hmpm(hmpm, matchoice = NULL, err_check = NULL)
}
\arguments{
\item{hmpm}{A historical matrix projection model of class \code{lefkoMat}.}

\item{matchoice}{A character denoting whether to use A, U, or F matrices.
Defaults to A matrices.}

\item{err_check}{A logical value denoting whether to include a data frame
of element equivalence from the conditional matrices to the original
matrices. Used only for debugging purposes. Defaults to FALSE.}
}
\value{
A \code{lefkoCondMat} object, with the following elements:

\item{Acond}{A multi-level list holding the conditional A matrices derived
from the input \code{lefkoMat} object. The top level of the list corresponds
to each historical matrix in turn, and the lower level corresponds to each
stage in time \emph{t}-1, with individual conditional matrices named for the
latter.}
\item{hstages}{A data frame matrix showing the pairing of ahistorical stages
used to create historical stage pairs.}
\item{ahstages}{A data frame detailing the characteristics of associated
ahistorical stages.}
\item{labels}{A data frame showing the patch and year of each input full A 
matrix in order.}
}
\description{
Function \code{cond_hmpm()} takes historical MPMs and decomposes them into 
ahistorical matrices conditional upon stage in time \emph{t}-1. In effect,
the function takes each historical matrix within a lefkoMat object, and
forms one ahistorical matrix for each stage in time \emph{t}-1.
}
\examples{
data(cypdata)
 
sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md",
  "Lg", "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4, 
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04", 
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE, 
  NRasRep = TRUE)

rep_cyp_raw <- matrix(0, 11, 11)
rep_cyp_raw[1:2,7:11] <- 0.5

cypover3r <- overwrite(stage3 = c("SD", "SD", "P1", "P1", "P2", "P3", "SL", 
    "SL", "SL", "D", "XSm", "Sm", "D", "XSm", "Sm"), 
  stage2 = c("SD", "SD", "SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", 
    "SL", "SL", "SL", "SL", "SL"),
  stage1 = c("SD", "rep", "SD", "rep", "SD", "P1", "P2", "P3", "SL", "P3", 
    "P3", "P3", "SL", "SL", "SL"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", "D", 
    "XSm", "Sm"), 
  eststage2 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", 
    "XSm", "XSm", "XSm"), 
  eststage1 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", 
    "XSm", "XSm", "XSm"), 
  givenrate = c(0.1, 0.1, 0.2, 0.2, 0.2, 0.2, 0.25, 0.4, 0.4, NA, NA, NA, 
    NA, NA, NA), 
  type = c("S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S",
    "S", "S"))

cypmatrix3r <- rlefko3(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added", "size1added"), 
  repmatrix = rep_cyp_raw, overwrite = cypover3r, yearcol = "year2", 
  patchcol = "patchid", indivcol = "individ")

cypcondmats <- cond_hmpm(cypmatrix3r)
summary(cypcondmats)

}
