% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{sensitivity3.lefkoMat}
\alias{sensitivity3.lefkoMat}
\title{Estimate Sensitivity of Population Growth Rate of a lefkoMat Object}
\usage{
\method{sensitivity3}{lefkoMat}(
  mats,
  stochastic = FALSE,
  times = 10000,
  tweights = NA,
  seed = NA,
  sparse = "auto",
  append_mats = FALSE,
  ...
)
}
\arguments{
\item{mats}{An object of class \code{lefkoMat}.}

\item{stochastic}{A logical value determining whether to conduct a
deterministic (FALSE) or stochastic (TRUE) sensitivity analysis. Defaults to
FALSE.}

\item{times}{The number of occasions to project forward in stochastic
simulation. Defaults to \code{10000}.}

\item{tweights}{An optional numeric vector or matrix denoting the
probabilities of choosing each matrix in a stochastic projection. If a matrix
is input, then a first-order Markovian environment is assumed, in which the
probability of choosing a specific annual matrix depends on which annual
matrix is currently chosen. If a vector is input, then the choice of annual
matrix is assumed to be independent of the current matrix. Defaults to equal
weighting among matrices.}

\item{seed}{A number to use as a random number seed in stochastic projection.}

\item{sparse}{A text string indicating whether to use sparse matrix encoding
(\code{"yes"}) or dense matrix encoding (\code{"no"}). Defaults to
\code{"auto"}, in which case sparse matrix encoding is used with square
matrices with at least 50 rows and no more than 50\% of elements with values
greater than zero.}

\item{append_mats}{A logical value indicating whether to include the original
A, U, and F matrices in the output \code{lefkoSens} object.}

\item{...}{Other parameters.}
}
\value{
This function returns an object of class \code{lefkoSens}, which is a
list of 8 elements. The first, \code{h_sensmats}, is a list of historical
sensitivity matrices (\code{NULL} if an ahMPM is used as input). The second,
\code{ah_elasmats}, is a list of either ahistorical sensitivity matrices if
an ahMPM is used as input, or, if an hMPM is used as input, then the result
is a list of ahistorical matrices based on the equivalent historical
dependencies assumed in the input historical matrices. The third element,
\code{hstages}, is a data frame showing historical stage pairs (\code{NULL}
if an ahMPM used as input). The fourth element, \code{agestages}, show the
order of age-stage combinations, if age-by-stage MPMs have been supplied. The
fifth element, \code{ahstages}, is a data frame showing the order of
ahistorical stages. The last 3 elements are the A, U, and F portions of the
input.
}
\description{
\code{sensitivity3.lefkoMat()} returns the sensitivities of population growth
rate to elements of all \code{$A} matrices in an object of class
\code{lefkoMat}. If deterministic, then \eqn{\lambda} is taken as the
population growth rate. If stochastic, then the log of stochastic
\eqn{\lambda}, or the log stochastic growth rate, is taken as the population
growth rate. This function can handle large and sparse matrices, and so can
be used with large historical matrices, IPMs, age x stage matrices, as well
as smaller ahistorical matrices.
}
\section{Notes}{

All sensitivity matrix outputs from this function are in standard matrix
format.

Deterministic sensitivities are estimated as eqn. 9.14 in Caswell (2001,
Matrix Population Models). Stochastic sensitivities are estimated as eqn.
14.97 in Caswell (2001). Note that stochastic sensitivities are of the log of
the stochastic \eqn{\lambda}.

Speed can sometimes be increased by shifting from automatic sparse matrix
determination to forced dense or sparse matrix projection. This will most
likely occur when matrices have between 30 and 300 rows and columns.
Defaults work best when matrices are very small and dense, or very large and
sparse.

The \code{time_weights} and \code{steps} arguments are now deprecated.
Instead, please use the \code{tweights} and \code{times} arguments.
}

\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

sensitivity3(ehrlen3, stochastic = TRUE)

}
\seealso{
\code{\link{sensitivity3}()}

\code{\link{sensitivity3.matrix}()}

\code{\link{sensitivity3.dgCMatrix}()}

\code{\link{sensitivity3.list}()}
}
