% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted.R
\name{lev_weighted_token_ratio}
\alias{lev_weighted_token_ratio}
\title{Weighted token similarity measure}
\usage{
lev_weighted_token_ratio(a, b, weights = list(), ...)
}
\arguments{
\item{a, b}{The input strings}

\item{weights}{List of token weights. For example, \code{weights = list(foo = 0.9, bar = 0.1)}. Any
tokens omitted from \code{weights} will be given a weight of 1.}

\item{...}{Additional arguments to be passed to \code{\link[stringdist:stringdist]{stringdist::stringdistmatrix()}} or
\code{\link[stringdist:stringsim]{stringdist::stringsimmatrix()}}.}
}
\value{
A float
}
\description{
Computes similarity but allows you to assign weights to specific tokens. This is useful, for
example, when you have a frequently-occurring string that doesn't contain useful information. See
examples.
}
\section{Details}{
The algorithm used here is as follows:
\itemize{
\item Tokenise the input strings
\item Compute the edit distance between each pair of tokens
\item Compute the maximum edit distance between each pair of tokens
\item Apply any weights from the \code{weights} argument
\item Return \code{1 - (sum(weighted_edit_distances) / sum(weighted_max_edit_distance))}
}
}

\examples{
lev_weighted_token_ratio("jim ltd", "tim ltd")

lev_weighted_token_ratio("tim ltd", "jim ltd", weights = list(ltd = 0.1))
}
\seealso{
Other weighted token functions: 
\code{\link{lev_weighted_token_set_ratio}()},
\code{\link{lev_weighted_token_sort_ratio}()}
}
\concept{weighted token functions}
