test_that("raisedcos", {
    expect_equal(raisedcos(-5,  0, 1, 2), 0)
    expect_equal(raisedcos(-1,  0, 1, 2), 0)
    expect_equal(raisedcos(0,   0, 1, 2), 0)
    expect_equal(raisedcos(0.5, 0, 1, 2), 0.5)
    expect_equal(raisedcos(1,   0, 1, 2), 1)
    expect_equal(raisedcos(1.5, 0, 1, 2), 0.5)
    expect_equal(raisedcos(2,   0, 1, 2), 0)
    expect_equal(raisedcos(10,  0, 1, 2), 0)

    expect_equal(raisedcos(-1,  1, 1, 2), 0)
    expect_equal(raisedcos(0,   1, 1, 2), 0)
    expect_equal(raisedcos(1,   1, 1, 2), 1)
    expect_equal(raisedcos(1.5, 1, 1, 2), 0.5)
    expect_equal(raisedcos(2,   1, 1, 2), 0)
    expect_equal(raisedcos(10,  1, 1, 2), 0)

    expect_equal(raisedcos(-1,  0, 1, 1), 0)
    expect_equal(raisedcos(0,   0, 1, 1), 0)
    expect_equal(raisedcos(0.5, 0, 1, 1), 0.5)
    expect_equal(raisedcos(1,   0, 1, 1), 1)
    expect_equal(raisedcos(2,   0, 1, 1), 0)
    expect_equal(raisedcos(10,  0, 1, 1), 0)

    expect_equal(raisedcos(0,   1, 1, 1), 0)
    expect_equal(raisedcos(1,   1, 1, 1), 1)
    expect_equal(raisedcos(2,   1, 1, 1), 0)

    expect_equal(raisedcos(-5,  -Inf, 1, 2), 1)
    expect_equal(raisedcos(0,   -Inf, 1, 2), 1)
    expect_equal(raisedcos(1,   -Inf, 1, 2), 1)
    expect_equal(raisedcos(1.5, -Inf, 1, 2), 0.5)
    expect_equal(raisedcos(2,   -Inf, 1, 2), 0)
    expect_equal(raisedcos(5,   -Inf, 1, 2), 0)

    expect_equal(raisedcos(0,   0, 1, Inf), 0)
    expect_equal(raisedcos(0.5, 0, 1, Inf), 0.5)
    expect_equal(raisedcos(1,   0, 1, Inf), 1)
    expect_equal(raisedcos(2,   0, 1, Inf), 1)
    expect_equal(raisedcos(5,   0, 1, Inf), 1)

    expect_equal(raisedcos(-5,  -Inf, 1, Inf), 1)
    expect_equal(raisedcos(0,   -Inf, 1, Inf), 1)
    expect_equal(raisedcos(1,   -Inf, 1, Inf), 1)
    expect_equal(raisedcos(2,   -Inf, 1, Inf), 1)
    expect_equal(raisedcos(5,   -Inf, 1, Inf), 1)

    expect_equal(raisedcos(1,   -Inf, -Inf, Inf), 1)
    expect_equal(raisedcos(1,   -Inf, Inf, Inf), 1)
})
