% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugeno.R
\name{sugeno}
\alias{sugeno}
\title{A factory function for creation of sugeno-integrals.}
\usage{
sugeno(
  measure,
  relative = TRUE,
  strong = FALSE,
  alg = c("lukasiewicz", "goedel", "goguen")
)
}
\arguments{
\item{measure}{A non-decreasing function that assigns a truth value from the
\eqn{[0, 1]} interval to the either relative or absolute quantity}

\item{relative}{Whether the measure assumes relative or absolute quantity.
Relative quantity is always a number from the \eqn{[0,1]} interval}

\item{strong}{Whether to use the strong conjunction (\code{TRUE}) or the weak
conjunction (\code{FALSE})}

\item{alg}{The underlying algebra must be either a string (one from 'lukasiewicz',
'goedel' or 'goguen') or an instance of the S3 class \code{\link[=algebra]{algebra()}}.}
}
\value{
A two-argument function, which expects two numeric vectors of equal length
(the vector elements are recycled to ensure equal lengths). The first argument, \code{x},
is a vector of membership degrees to be measured, the second argument, \code{w}, is
the vector of weights.

Let \eqn{U} be the set of input vector indices (1 to \code{length(x)}). Then the sugeno integral
computes the truth values accordingly to the following formula:
\eqn{\vee_{z \subseteq U} \wedge_{u \in z} (x[u]) CONJ measure(m_z)},
where
\eqn{m_z = sum(w[z]) / sum(w)} if \code{relative==TRUE} or \eqn{m_z = sum(w)} if \code{relative==FALSE}
and where CONJ is a strong conjunction (i.e. \code{alg$pt}) or a weak conjunction
(i.e. \code{alg$pi}) accordingly to the \code{strong} parameter.
}
\description{
A factory function for creation of sugeno-integrals.
}
\examples{
  # Dvorak <1> "almost all" quantifier
  q <- sugeno(lingexpr(ctx3(), atomic='bi', hedge='ex'))
  a <- c(0.9, 1, 1, 0.2, 1)
  q(x=a, w=1)

  # Dvorak <1,1> "almost all" quantifier
  a <- c(0.9, 1, 1, 0.2, 1)
  b <- c(0.2, 1, 0, 0.5, 0.8)
  q <- sugeno(lingexpr(ctx3(), atomic='bi', hedge='ex'))
  q(x=lukas.residuum(a, b), w=1)

  # Murinová <1,1> "almost all" quantifier
  a <- c(0.9, 1, 1, 0.2, 1)
  b <- c(0.2, 1, 0, 0.5, 0.8)
  q <- sugeno(lingexpr(ctx3(), atomic='bi', hedge='ex'))
  q(x=lukas.residuum(a, b), w=a)
}
\seealso{
\code{\link[=quantifier]{quantifier()}}, \code{\link[=lingexpr]{lingexpr()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
