% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main-pred.R
\name{pred}
\alias{pred}
\title{Posterior predictions and function posteriors}
\usage{
pred(
  fit,
  x = NULL,
  reduce = function(x) base::mean(x),
  draws = NULL,
  verbose = TRUE,
  STREAM = get_stream(),
  c_hat_pred = NULL,
  force = FALSE
)
}
\arguments{
\item{fit}{An object of class \linkS4class{lgpfit}.}

\item{x}{A data frame of points where function posterior distributions
and predictions should be computed or sampled.
The function \code{\link{new_x}} provides an easy way to create it.
If this is \code{NULL}, the data points are used.}

\item{reduce}{Reduction for parameters draws. Can be a function that
is applied to reduce all parameter draws into one parameter set, or
\code{NULL} (no reduction). Has no effect if \code{draws} is specified.}

\item{draws}{Indices of parameter draws to use, or \code{NULL} to use all
draws.}

\item{verbose}{Should more information and a possible progress bar be
printed?}

\item{STREAM}{External pointer. By default obtained with
\code{rstan::get_stream()}.}

\item{c_hat_pred}{This is only used if the latent signal \code{f} was
sampled. This input contains the values added to the sum \code{f} before
passing through inverse link function. Must be a vector with length equal to
the number of prediction points. If original \code{c_hat} was constant,
then \code{c_hat_pred} can be ignored, in which case this will by default
use the same constant.}

\item{force}{This is by default \code{FALSE} to prevent unintended
large computations that might crash R or take forever. Set it to \code{TRUE}
try computing no matter what.}
}
\value{
An object of class \linkS4class{GaussianPrediction} or
\linkS4class{Prediction}.
}
\description{
\itemize{
  \item If \code{fit} is for a model that marginalizes the latent
  signal \code{f} (i.e. \code{is_f_sampled(fit)} is \code{FALSE}), this
  computes the analytic conditional posterior
  distributions of each model component, their sum, and the conditional
  predictive distribution. All these are computed for
  each (hyper)parameter draw (defined by \code{draws}), or other parameter
  set (obtained by a reduction defined by \code{reduce}). Results are stored
  in a \linkS4class{GaussianPrediction} object which is then returned.

  \item If \code{fit} is for a model that samples the latent
  signal \code{f} (i.e. \code{is_f_sampled(fit)} is \code{TRUE}), this will
  extract these function samples, compute their sum, and a version of the
  sum \code{f} that is transformed through the inverse link function.
  If \code{x} is not \code{NULL}, the function draws are extrapolated
  to the points specified by \code{x} using kernel regression.
  Results are stored in a \linkS4class{Prediction}
  object which is then returned.
}
}
\seealso{
Other main functions: 
\code{\link{create_model}()},
\code{\link{draw_pred}()},
\code{\link{get_draws}()},
\code{\link{lgp}()},
\code{\link{prior_pred}()},
\code{\link{sample_model}()}
}
\concept{main functions}
