% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\docType{package}
\name{lgpr-package}
\alias{lgpr-package}
\alias{lgpr}
\title{The 'lgpr' package.}
\description{
Interpretable nonparametric modeling of longitudinal data
using additive Gaussian process regression. Contains functionality
for inferring covariate effects and assessing covariate relevances.
Models are specified using a convenient formula syntax, and can include
shared, group-specific, non-stationary, heterogeneous and temporally
uncertain effects. Bayesian inference for model parameters is performed
using 'Stan' (\code{\link[rstan]{rstan}}). The modeling approach and methods
are described in detail in
\href{https://academic.oup.com/bioinformatics/advance-article/doi/10.1093/bioinformatics/btab021/6104850}{Timonen et al. (2021)}.
}
\section{Core functions}{

Main functionality of the package consists of creating and fitting an
additive GP model:
\itemize{
 \item \code{\link{lgp}}: Specify and fit an additive GP model with one
 command.
 \item \code{\link{create_model}}: Define an \linkS4class{lgpmodel} object.
 \item \code{\link{sample_model}}: Fit a model by sampling the posterior
 distribution of its parameters and create an \linkS4class{lgpfit} object.
 \item \code{\link{pred}}: Computing model predictions and inferred
 covariate effects after fitting a model.
 \item \code{\link{relevances}}: Assessing covariate relevances after
 fitting a model.
 \item \code{\link{prior_pred}}: Prior predictive sampling to check
 if your prior makes sense.
}
}

\section{Visualization}{

\itemize{
 \item \code{\link{plot_pred}}: Plot model predictions.
 \item \code{\link{plot_components}}: Visualize inferred model components.
 \item \code{\link{plot_draws}}: Visualize parameter draws.
 \item \code{\link{plot_data}}: Visualize longitudinal data.
}
}

\section{Data}{

The data that you wish to analyze with 'lgpr' should be in an \R
\code{data.frame} where columns correspond to measured variables and rows
correspond to observations. Some functions that can help working with such
data frames are:
\itemize{
 \item \code{\link{new_x}}: Creating new test points where the posterior
 distribution of any function component or sum of all components, or the
 posterior predictive distribution can be computed after model fitting.
 \item Other functions: \code{\link{add_factor}},
 \code{\link{add_factor_crossing}}, \code{\link{add_dis_age}},
 \code{\link{adjusted_c_hat}}.
}
}

\section{Vignettes and tutorials}{

See \url{https://jtimonen.github.io/lgpr-usage/index.html}. The
tutorials focus on code and use cases, whereas the
\href{https://jtimonen.github.io/lgpr-usage/articles/math.html}{Mathematical description of lgpr models}
vignette describes the statistical models and how they can be customized in 'lgpr'.
}

\section{Citation}{

Run \code{citation("lgpr")} to get citation information.
}

\section{Feedback}{

Bug reports, PRs, enhancement ideas or user experiences in general are
welcome and appreciated. Create an issue in Github or email the author.
}

\references{
\enumerate{
  \item Timonen, J. et al. (2021).
  \emph{lgpr: an interpretable non-parametric method for inferring covariate
  effects from longitudinal data}. Bioinformatics,
  \href{https://academic.oup.com/bioinformatics/advance-article/doi/10.1093/bioinformatics/btab021/6104850}{url}.
  \item Carpenter, B. et al. (2017).
  \emph{Stan: A probabilistic programming language}. Journal of Statistical
   Software 76(1).
}
}
\author{
Juho Timonen (first.last at iki.fi)
}
\keyword{Bayesian}
\keyword{GP}
\keyword{Stan}
\keyword{additive}
\keyword{covariate}
\keyword{interpretable}
\keyword{longitudinal}
\keyword{model}
\keyword{relevance}
