% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsattr.R
\encoding{UTF-8}
\name{dsattr}
\alias{dsattr}
\title{Assign Datastep Variable Attributes}
\usage{
dsattr(
  default = NA,
  label = NULL,
  description = NULL,
  width = NULL,
  format = NULL,
  justify = NULL,
  ...
)
}
\arguments{
\item{default}{The default value of the column.  The default value can
be any valid data value. Typical default 
values might be an empty string ("") or a zero (0).  If no
default value is specified, the column will be defaulted to NA.}

\item{label}{The label to associate with this column.  Accepts
any string value. The label will appear as a column header on some 
data viewers and reporting packages.}

\item{description}{A description for this column.  Accepts any string
value.  The description is intended to be a longer explanation of the 
purpose or source of the variable.}

\item{width}{The desired width for the column in number of characters.}

\item{format}{The format associated with this column.  See the 
\code{\link[fmtr]{fmtr}} package for more information about formatting.}

\item{justify}{The desired justification for the column.  This parameter
it normally used only for fixed-width, character columns.  Valid values
are 'left', 'right', 'center', and 'centre'.}

\item{...}{Any other attributes you wish to assign to this column. Pass
these additional attributes as a name/value pair.}
}
\value{
The data step attributes object.
}
\description{
An object to assign attributes
to a column in a \code{\link{datastep}}.  The parameters allow you
to set the following attributes: 'class', 'label', 'description', 'width', 
'justify', and 'format'.  Any other desired attributes can be set 
with \code{...}.

The attributes available in the \code{dsattr} class are closely aligned
with those available on the \code{\link{dictionary}} object.
}
\examples{
library(libr)

# Create small sample dataframe
dat <- mtcars[1:10, c("mpg", "cyl")]

# Perform datastep and assign attributes
dat1 <- datastep(dat, 
                 attrib = list(mpg = dsattr(label = "Miles Per Gallon"),
                               cyl = dsattr(label = "Cylinders"),
                               mpgcat = dsattr(label = "Fuel Efficiency")),
                {
                
                  if (mpg >= 20) 
                    mpgcat = "High"
                  else 
                    mpgcat = "Low"
                
                })

# Print results                 
dat1
#                    mpg cyl mpgcat
# Mazda RX4         21.0   6   High
# Mazda RX4 Wag     21.0   6   High
# Datsun 710        22.8   4   High
# Hornet 4 Drive    21.4   6   High
# Hornet Sportabout 18.7   8    Low
# Valiant           18.1   6    Low
# Duster 360        14.3   8    Low
# Merc 240D         24.4   4   High
# Merc 230          22.8   4   High
# Merc 280          19.2   6    Low
                
# Examine label attributes
attr(dat1$mpg, "label") 
# [1] "Miles Per Gallon"

attr(dat1$cyl, "label") 
# [1] "Cylinders"

attr(dat1$mpgcat, "label")
# [1] "Fuel Efficiency"

# See labels in viewer 
# View(dat1)
}
\seealso{
\code{\link{dictionary}} function to observe the attributes
associated with a dataset.  Also see the \code{\link[fmtr]{fdata}} 
function in the \strong{fmtr}
package for more information on formatting and rendering data frames.

Other datastep: 
\code{\link{[.dsarray}()},
\code{\link{datastep}()},
\code{\link{dsarray}()},
\code{\link{length.dsarray}()}
}
\concept{datastep}
