% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datastep.R
\name{delete}
\alias{delete}
\title{Removes an observation from a datastep}
\usage{
delete()
}
\value{
Observation is marked with a delete flag.  No return value.
}
\description{
The \code{delete} function will remove an observation
from the output of a datastep.  The function takes no parameters.  To use 
the function, simply call it on the rows you want to delete.  Typically
it is called within a conditional.
}
\examples{
#' # Remove all cars that are not 4 cylinder
df <- datastep(mtcars, 
               keep = c("mpg", "cyl", "disp"), {
                 
  if (cyl != 4)
    delete()
                 
})

df
#     mpg cyl  disp
# 1  22.8   4 108.0
# 2  24.4   4 146.7
# 3  22.8   4 140.8
# 4  32.4   4  78.7
# 5  30.4   4  75.7
# 6  33.9   4  71.1
# 7  21.5   4 120.1
# 8  27.3   4  79.0
# 9  26.0   4 120.3
# 10 30.4   4  95.1
# 11 21.4   4 121.0
}
\seealso{
Other datastep: 
\code{\link{[.dsarray}()},
\code{\link{datastep}()},
\code{\link{dsarray}()},
\code{\link{dsattr}()},
\code{\link{length.dsarray}()},
\code{\link{output}()}
}
\concept{datastep}
