/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_ESTIMATES_H
#define _SO_ESTIMATES_H

#include <so/Table.h>

/** \struct so_Estimates
	 \brief A structure representing an SO/SOBlock/Estimation/IndividualEstimates/Estimates element
*/
typedef struct so_Estimates so_Estimates;

/** \memberof so_Estimates
 * Create a new empty so_Estimates structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_Estimates_copy, so_Estimates_free
 */
so_Estimates *so_Estimates_new();
/** \memberof so_Estimates
 * Create a copy of a so_Estimates structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_Estimates_new
 */
so_Estimates *so_Estimates_copy(so_Estimates *self);
/** \memberof so_Estimates
 * Free all memory associated with a so_Estimates structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_Estimates_new
 */
void so_Estimates_free(so_Estimates *self);
void so_Estimates_ref(so_Estimates *self);
void so_Estimates_unref(so_Estimates *self);
/** \memberof so_Estimates
 * Get the Mean element
 * \param self - pointer to a so_Estimates
 * \return A pointer to the structure representing the Mean element
 * \sa so_Estimates_set_Mean
 */
so_Table *so_Estimates_get_Mean(so_Estimates *self);
/** \memberof so_Estimates
 * Get the Median element
 * \param self - pointer to a so_Estimates
 * \return A pointer to the structure representing the Median element
 * \sa so_Estimates_set_Median
 */
so_Table *so_Estimates_get_Median(so_Estimates *self);
/** \memberof so_Estimates
 * Get the Mode element
 * \param self - pointer to a so_Estimates
 * \return A pointer to the structure representing the Mode element
 * \sa so_Estimates_set_Mode
 */
so_Table *so_Estimates_get_Mode(so_Estimates *self);
/** \memberof so_Estimates
 * Get the Samples element
 * \param self - pointer to a so_Estimates
 * \return A pointer to the structure representing the Samples element
 * \sa so_Estimates_set_Samples
 */
so_Table *so_Estimates_get_Samples(so_Estimates *self);
/** \memberof so_Estimates
 * Set the Mean element
 * \param self - pointer to a so_Estimates
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_Estimates_get_Mean
 */
void so_Estimates_set_Mean(so_Estimates *self, so_Table *value);
/** \memberof so_Estimates
 * Set the Median element
 * \param self - pointer to a so_Estimates
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_Estimates_get_Median
 */
void so_Estimates_set_Median(so_Estimates *self, so_Table *value);
/** \memberof so_Estimates
 * Set the Mode element
 * \param self - pointer to a so_Estimates
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_Estimates_get_Mode
 */
void so_Estimates_set_Mode(so_Estimates *self, so_Table *value);
/** \memberof so_Estimates
 * Set the Samples element
 * \param self - pointer to a so_Estimates
 * \param value - A pointer to a \a so_Table to set.
 * \sa so_Estimates_get_Samples
 */
void so_Estimates_set_Samples(so_Estimates *self, so_Table *value);
/** \memberof so_Estimates
 * Create a new Mean element and insert it into the so_Estimates
 * \param self - pointer to a so_Estimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_Estimates_create_Mean(so_Estimates *self);
/** \memberof so_Estimates
 * Create a new Median element and insert it into the so_Estimates
 * \param self - pointer to a so_Estimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_Estimates_create_Median(so_Estimates *self);
/** \memberof so_Estimates
 * Create a new Mode element and insert it into the so_Estimates
 * \param self - pointer to a so_Estimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_Estimates_create_Mode(so_Estimates *self);
/** \memberof so_Estimates
 * Create a new Samples element and insert it into the so_Estimates
 * \param self - pointer to a so_Estimates
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Table *so_Estimates_create_Samples(so_Estimates *self);

#endif
