/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/MLE.h>
#include <so/private/MLE.h>

so_MLE *so_MLE_new()
{
	so_MLE *object = calloc(sizeof(so_MLE), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_MLE *so_MLE_copy(so_MLE *self)
{
	so_MLE *dest = so_MLE_new();
	if (dest) {
		if (self->FIM) {
			dest->FIM = so_Matrix_copy(self->FIM);
			if (!dest->FIM) {
				so_MLE_free(dest);
				return NULL;
			}
		}
		if (self->CovarianceMatrix) {
			dest->CovarianceMatrix = so_Matrix_copy(self->CovarianceMatrix);
			if (!dest->CovarianceMatrix) {
				so_MLE_free(dest);
				return NULL;
			}
		}
		if (self->CorrelationMatrix) {
			dest->CorrelationMatrix = so_Matrix_copy(self->CorrelationMatrix);
			if (!dest->CorrelationMatrix) {
				so_MLE_free(dest);
				return NULL;
			}
		}
		if (self->StandardError) {
			dest->StandardError = so_Table_copy(self->StandardError);
			if (!dest->StandardError) {
				so_MLE_free(dest);
				return NULL;
			}
		}
		if (self->RelativeStandardError) {
			dest->RelativeStandardError = so_Table_copy(self->RelativeStandardError);
			if (!dest->RelativeStandardError) {
				so_MLE_free(dest);
				return NULL;
			}
		}
		if (self->AsymptoticCI) {
			dest->AsymptoticCI = so_Table_copy(self->AsymptoticCI);
			if (!dest->AsymptoticCI) {
				so_MLE_free(dest);
				return NULL;
			}
		}
		if (self->ConditionNumber) {
			dest->ConditionNumber_number = self->ConditionNumber_number;
			dest->ConditionNumber = &(dest->ConditionNumber_number);
		}
	}

	return dest;
}

void so_MLE_free(so_MLE *self)
{
	if (self) {
		so_Matrix_unref(self->FIM);
		so_Matrix_unref(self->CovarianceMatrix);
		so_Matrix_unref(self->CorrelationMatrix);
		so_Table_unref(self->StandardError);
		so_Table_unref(self->RelativeStandardError);
		so_Table_unref(self->AsymptoticCI);
		free(self);
	}
}

void so_MLE_ref(so_MLE *self)
{
	self->reference_count++;
}

void so_MLE_unref(so_MLE *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_MLE_free(self);
		}
	}
}

so_Matrix *so_MLE_get_FIM(so_MLE *self)
{
	return self->FIM;
}

so_Matrix *so_MLE_get_CovarianceMatrix(so_MLE *self)
{
	return self->CovarianceMatrix;
}

so_Matrix *so_MLE_get_CorrelationMatrix(so_MLE *self)
{
	return self->CorrelationMatrix;
}

so_Table *so_MLE_get_StandardError(so_MLE *self)
{
	return self->StandardError;
}

so_Table *so_MLE_get_RelativeStandardError(so_MLE *self)
{
	return self->RelativeStandardError;
}

so_Table *so_MLE_get_AsymptoticCI(so_MLE *self)
{
	return self->AsymptoticCI;
}

double *so_MLE_get_ConditionNumber(so_MLE *self)
{
	return self->ConditionNumber;
}

void so_MLE_set_FIM(so_MLE *self, so_Matrix *value)
{
	so_Matrix_unref(self->FIM);
	self->FIM = value;
}

void so_MLE_set_CovarianceMatrix(so_MLE *self, so_Matrix *value)
{
	so_Matrix_unref(self->CovarianceMatrix);
	self->CovarianceMatrix = value;
}

void so_MLE_set_CorrelationMatrix(so_MLE *self, so_Matrix *value)
{
	so_Matrix_unref(self->CorrelationMatrix);
	self->CorrelationMatrix = value;
}

void so_MLE_set_StandardError(so_MLE *self, so_Table *value)
{
	so_Table_unref(self->StandardError);
	self->StandardError = value;
}

void so_MLE_set_RelativeStandardError(so_MLE *self, so_Table *value)
{
	so_Table_unref(self->RelativeStandardError);
	self->RelativeStandardError = value;
}

void so_MLE_set_AsymptoticCI(so_MLE *self, so_Table *value)
{
	so_Table_unref(self->AsymptoticCI);
	self->AsymptoticCI = value;
}

void so_MLE_set_ConditionNumber(so_MLE *self, double *value)
{
	if (value) {
		self->ConditionNumber_number = *value;
		self->ConditionNumber = &(self->ConditionNumber_number);
	} else {
		self->ConditionNumber = value;
	}
}

so_Matrix *so_MLE_create_FIM(so_MLE *self)
{
	so_Matrix *obj = so_Matrix_new("FIM");
	if (obj) {
		self->FIM = obj;
	}
	return obj;
}

so_Matrix *so_MLE_create_CovarianceMatrix(so_MLE *self)
{
	so_Matrix *obj = so_Matrix_new("CovarianceMatrix");
	if (obj) {
		self->CovarianceMatrix = obj;
	}
	return obj;
}

so_Matrix *so_MLE_create_CorrelationMatrix(so_MLE *self)
{
	so_Matrix *obj = so_Matrix_new("CorrelationMatrix");
	if (obj) {
		self->CorrelationMatrix = obj;
	}
	return obj;
}

so_Table *so_MLE_create_StandardError(so_MLE *self)
{
	so_Table *obj = so_Table_new("StandardError");
	if (obj) {
		self->StandardError = obj;
	}
	return obj;
}

so_Table *so_MLE_create_RelativeStandardError(so_MLE *self)
{
	so_Table *obj = so_Table_new("RelativeStandardError");
	if (obj) {
		self->RelativeStandardError = obj;
	}
	return obj;
}

so_Table *so_MLE_create_AsymptoticCI(so_MLE *self)
{
	so_Table *obj = so_Table_new("AsymptoticCI");
	if (obj) {
		self->AsymptoticCI = obj;
	}
	return obj;
}

int so_MLE_xml(so_MLE *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->FIM || self->CovarianceMatrix || self->CorrelationMatrix || self->StandardError || self->RelativeStandardError || self->AsymptoticCI || self->ConditionNumber) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "MLE");
		if (rc < 0) return 1;
		if (self->FIM) {
			rc = so_Matrix_xml(self->FIM, writer, "FIM");
			if (rc != 0) return rc;
		}
		if (self->CovarianceMatrix) {
			rc = so_Matrix_xml(self->CovarianceMatrix, writer, "CovarianceMatrix");
			if (rc != 0) return rc;
		}
		if (self->CorrelationMatrix) {
			rc = so_Matrix_xml(self->CorrelationMatrix, writer, "CorrelationMatrix");
			if (rc != 0) return rc;
		}
		if (self->StandardError) {
			rc = so_Table_xml(self->StandardError, writer, "StandardError");
			if (rc != 0) return rc;
		}
		if (self->RelativeStandardError) {
			rc = so_Table_xml(self->RelativeStandardError, writer, "RelativeStandardError");
			if (rc != 0) return rc;
		}
		if (self->AsymptoticCI) {
			rc = so_Table_xml(self->AsymptoticCI, writer, "AsymptoticCI");
			if (rc != 0) return rc;
		}
		if (self->ConditionNumber) {
			char *number_string = pharmml_double_to_string(self->ConditionNumber_number);
			if (!number_string) return 1;
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "ConditionNumber", BAD_CAST number_string);
			free(number_string);
			if (rc < 0) return 1;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_MLE_start_element(so_MLE *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_FIM) {
		int fail = so_Matrix_start_element(self->FIM, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_CovarianceMatrix) {
		int fail = so_Matrix_start_element(self->CovarianceMatrix, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_CorrelationMatrix) {
		int fail = so_Matrix_start_element(self->CorrelationMatrix, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_StandardError) {
		int fail = so_Table_start_element(self->StandardError, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_RelativeStandardError) {
		int fail = so_Table_start_element(self->RelativeStandardError, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_AsymptoticCI) {
		int fail = so_Table_start_element(self->AsymptoticCI, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "FIM") == 0) {
		so_Matrix *FIM = so_MLE_create_FIM(self);
		if (!FIM) {
			return 1;
		}
		self->in_FIM = 1;
	} else if (strcmp(localname, "CovarianceMatrix") == 0) {
		so_Matrix *CovarianceMatrix = so_MLE_create_CovarianceMatrix(self);
		if (!CovarianceMatrix) {
			return 1;
		}
		self->in_CovarianceMatrix = 1;
	} else if (strcmp(localname, "CorrelationMatrix") == 0) {
		so_Matrix *CorrelationMatrix = so_MLE_create_CorrelationMatrix(self);
		if (!CorrelationMatrix) {
			return 1;
		}
		self->in_CorrelationMatrix = 1;
	} else if (strcmp(localname, "StandardError") == 0) {
		so_Table *StandardError = so_MLE_create_StandardError(self);
		if (!StandardError) {
			return 1;
		}
		self->in_StandardError = 1;
	} else if (strcmp(localname, "RelativeStandardError") == 0) {
		so_Table *RelativeStandardError = so_MLE_create_RelativeStandardError(self);
		if (!RelativeStandardError) {
			return 1;
		}
		self->in_RelativeStandardError = 1;
	} else if (strcmp(localname, "AsymptoticCI") == 0) {
		so_Table *AsymptoticCI = so_MLE_create_AsymptoticCI(self);
		if (!AsymptoticCI) {
			return 1;
		}
		self->in_AsymptoticCI = 1;
	} else if (strcmp(localname, "ConditionNumber") == 0) {
		self->in_ConditionNumber = 1;
	}
	return 0;
}

void so_MLE_end_element(so_MLE *self, const char *localname)
{
	if (strcmp(localname, "FIM") == 0 && self->in_FIM) {
		self->in_FIM = 0;
	} else if (strcmp(localname, "CovarianceMatrix") == 0 && self->in_CovarianceMatrix) {
		self->in_CovarianceMatrix = 0;
	} else if (strcmp(localname, "CorrelationMatrix") == 0 && self->in_CorrelationMatrix) {
		self->in_CorrelationMatrix = 0;
	} else if (strcmp(localname, "StandardError") == 0 && self->in_StandardError) {
		self->in_StandardError = 0;
	} else if (strcmp(localname, "RelativeStandardError") == 0 && self->in_RelativeStandardError) {
		self->in_RelativeStandardError = 0;
	} else if (strcmp(localname, "AsymptoticCI") == 0 && self->in_AsymptoticCI) {
		self->in_AsymptoticCI = 0;
	} else if (strcmp(localname, "ConditionNumber") == 0 && self->in_ConditionNumber) {
		self->in_ConditionNumber = 0;
	} else if (self->in_FIM) {
		so_Matrix_end_element(self->FIM, localname);
	} else if (self->in_CovarianceMatrix) {
		so_Matrix_end_element(self->CovarianceMatrix, localname);
	} else if (self->in_CorrelationMatrix) {
		so_Matrix_end_element(self->CorrelationMatrix, localname);
	} else if (self->in_StandardError) {
		so_Table_end_element(self->StandardError, localname);
	} else if (self->in_RelativeStandardError) {
		so_Table_end_element(self->RelativeStandardError, localname);
	} else if (self->in_AsymptoticCI) {
		so_Table_end_element(self->AsymptoticCI, localname);
	}
}

int so_MLE_characters(so_MLE *self, const char *ch, int len)
{
	if (self->in_FIM) {
		int fail = so_Matrix_characters(self->FIM, ch, len);
		if (fail) return 1;
	} else if (self->in_CovarianceMatrix) {
		int fail = so_Matrix_characters(self->CovarianceMatrix, ch, len);
		if (fail) return 1;
	} else if (self->in_CorrelationMatrix) {
		int fail = so_Matrix_characters(self->CorrelationMatrix, ch, len);
		if (fail) return 1;
	} else if (self->in_StandardError) {
		int fail = so_Table_characters(self->StandardError, ch, len);
		if (fail) return 1;
	} else if (self->in_RelativeStandardError) {
		int fail = so_Table_characters(self->RelativeStandardError, ch, len);
		if (fail) return 1;
	} else if (self->in_AsymptoticCI) {
		int fail = so_Table_characters(self->AsymptoticCI, ch, len);
		if (fail) return 1;
	} else if (self->in_ConditionNumber) {
		self->ConditionNumber_number = pharmml_string_to_double(ch);
		self->ConditionNumber = &(self->ConditionNumber_number);
	}
	return 0;
}
