% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog_retile.r
\name{catalog_retile}
\alias{catalog_retile}
\title{Retile a LAScatalog}
\usage{
catalog_retile(ctg)
}
\arguments{
\item{ctg}{A \link[lidR:catalog]{LAScatalog} object}
}
\value{
A new \code{LAScatalog} object
}
\description{
Splits or merges files to reshape the original catalog files (.las or .laz) into smaller or larger
files. It also enables the addition or removal of a buffer around the tiles. The function first
displays the layout of the new tiling pattern and then asks the user to validate the command.\cr
Internally, the function reads and writes the clusters defined by the internal processing options
of a \link[lidR:LAScatalog-class]{LAScatalog} processing engine. Thus, the function is flexible and
enables the user to retile the dataset, retile while adding or removing a buffer (negative buffers are
allowed), or optionally to compress the data by retiling without changing the pattern but by changing
the format (las/laz).\cr\cr
Note that this function is not actually very useful since \code{lidR} manages everything
(clipping, processing, buffering, ...) internally using the proper options. Thus, retiling may be
useful for working in other software, for example, but not in \code{lidR}.
}
\section{Working with a \code{LAScatalog}}{

This section appears in each function that supports a LAScatalog as input.\cr

In \code{lidR} when the input of a function is a \link[lidR:LAScatalog-class]{LAScatalog} the
function uses the LAScatalog processing engine. The user can modify the engine options using
the \link[lidR:catalog_options_tools]{available options}. A careful reading of the
\link[lidR:LAScatalog-class]{engine documentation} is recommended before processing \code{LAScatalogs}. Each
\code{lidR} function should come with a section that documents the supported engine options.\cr

The \code{LAScatalog} engine supports \code{.lax} files that \emph{significantly} improve the computation
speed of spatial queries using a spatial index. Users should really take advantage a \code{.lax} files,
but this is not mandatory.\cr
}

\section{Supported processing options}{

Supported processing options for a \code{LAScatalog} (in bold). For more details see the
\link[lidR:LAScatalog-class]{LAScatalog engine documentation}:
\itemize{
\item \strong{chunk_size}: Size of the new tiles.
\item \strong{buffer}: Load new tiles with a buffer. The expected value is usually 0.
\item \strong{alignment}: Alignment of the new tiles.
\item \strong{cores}: The number of cores used. \code{catalog_retile} streams the data (nothing is
loaded at th R level). The maximum number of cores can be safely used.
\item \strong{progress}: Displays a progress estimation.
\item \strong{output_files*}: Mandatory. The new tiles will be written in new files.
\item \strong{laz_compression}: save \code{las} or \code{laz} files.
\item select: \code{catalog_retile} preserve the file format anyway.
\item \strong{filter}: Retile and save only the points of interest.
}
}

\examples{
\dontrun{
ctg = readLAScatalog("path/to/catalog")

# Create a new set of .las files 500 x 500 wide in the folder
# path/to/new/catalog/ and iteratively named Forest_1.las, Forest_2.las
# Forest_3.las, and so on.

opt_chunk_buffer(ctg) <- 0
opt_chunk_size(ctg) <- 500
opt_output_files(ctg) <- "path/to/new/catalog/Forest_{ID}
newctg = catalog_retile(ctg)

# Create a new set of .las files equivalent to the original,
# but extended with a 50 m buffer in the folder path/to/new/catalog/
# and iteratively named named after the original files.

opt_chunk_buffer(ctg) <- 50
opt_chunk_size(ctg) <- 0
opt_output_files(ctg) <- "path/to/new/catalog/{ORIGINALFILENAME}_buffered
newctg = catalog_retile(ctg)

# Create a new set of compressed .laz file equivalent to the original, keeping only
# first returns above 2 m

opt_chunk_buffer(ctg) <- 0
opt_chunk_size(ctg) <- 0
opt_laz_compression(ctg) <- TRUE
opt_filter(ctg) <- "-keep_first -drop_z_below 2"
newctg = catalog_retile(ctg)
}
}
