% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_poi.R
\name{classify_poi}
\alias{classify_poi}
\title{Classify points of interest}
\usage{
classify_poi(
  las,
  class,
  poi = NULL,
  roi = NULL,
  inverse_roi = FALSE,
  by_reference = FALSE,
  ...
)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS} or \link[lidR:LAScatalog-class]{LAScatalog}.}

\item{class}{The ASPRS class to attribute to the points that meet the criterion.}

\item{poi}{a formula of logical predicates. The points that are \code{TRUE} will be classified \code{class}.}

\item{roi}{A \code{SpatialPolygons}, \code{SpatialPolygonDataFrame} from \code{sp} or a \code{POLYGON} from \code{sf}.
The points that are in the region of interest delimited by the polygon(s) are classified
\code{class}.}

\item{inverse_roi}{bool. Inverses the \code{roi}. The points that are outside the polygon(s)
are classified \code{class}}

\item{by_reference}{bool. Updates the classification in place (LAS only).}

\item{...}{Unused}
}
\value{
If the input is a \code{LAS} object, return a \code{LAS} object. If the input is a
\code{LAScatalog}, returns a \code{LAScatalog}.
}
\description{
Classify points that meet some logical criterion and/or that belong in a region of interest. The
function updates the attribute \code{Classification} of the LAS object.
}
\section{Working with a \code{LAScatalog}}{

This section appears in each function that supports a LAScatalog as input.\cr

In \code{lidR} when the input of a function is a \link[lidR:LAScatalog-class]{LAScatalog} the
function uses the LAScatalog processing engine. The user can modify the engine options using
the \link[lidR:catalog_options_tools]{available options}. A careful reading of the
\link[lidR:LAScatalog-class]{engine documentation} is recommended before processing \code{LAScatalogs}. Each
\code{lidR} function should come with a section that documents the supported engine options.\cr

The \code{LAScatalog} engine supports \code{.lax} files that \emph{significantly} improve the computation
speed of spatial queries using a spatial index. Users should really take advantage a \code{.lax} files,
but this is not mandatory.\cr
}

\section{Supported processing options}{

Supported processing options for a \code{LAScatalog} (in bold). For more details see the
\link[lidR:LAScatalog-class]{LAScatalog engine documentation}:
\itemize{
\item \strong{chunk size}: How much data is loaded at once.
\item chunk buffer: A buffer is not need for this function to works thus \code{buffer = 0}
and cannot be changed.
\item \strong{chunk alignment}: Align the processed chunks.
\item \strong{progress}: Displays a progression estimation.
\item \strong{output files*}: Mandatory because the output is likely to be too big to be returned
in R and needs to be written in las/laz files. Supported templates are \code{\{XLEFT\}}, \code{\{XRIGHT\}},
\code{\{YBOTTOM\}}, \code{\{YTOP\}}, \code{\{XCENTER\}}, \code{\{YCENTER\}} \code{\{ID\}} and, if
chunk size is equal to 0 (processing by file), \code{\{ORIGINALFILENAME\}}.
\item select: The function will write files equivalent to the original ones. Thus \code{select = "*"}
and cannot be changed.
\item \strong{filter}: Read only points of interest.
}
}

\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
shp     <- system.file("extdata", "lake_polygons_UTM17.shp", package = "lidR")

las  <- readLAS(LASfile, filter = "-keep_random_fraction 0.1")
lake <- sf::st_read(shp, quiet = TRUE)

# Classifies the points that are NOT in the lake and that are NOT ground points as class 5
poi <- ~Classification != LASGROUND
las <- classify_poi(las, LASHIGHVEGETATION, poi = poi, roi = lake, inverse = TRUE)

# Classifies the points that are in the lake as class 9
las <- classify_poi(las, LASWATER, roi = lake, inverse = FALSE)

#plot(las, color = "Classification")
}
